const path = require('path');
const express = require('express');
const cors = require('cors');
const http = require('http');
const { Server } = require('socket.io');

const pagesRouter = require('./routes/pages');
const orderRouter = require('./routes/order');
const authRouter = require('./routes/auth');

const app = express();
app.use(cors());
app.use(express.json());

// Serve static at /public (under BaseURI: /test/backend/public/...)
app.use('/public', express.static(path.join(__dirname, 'public')));

// APIs mounted at /api (under BaseURI: /test/backend/api/...)
app.use('/api/pages', pagesRouter);
app.use('/api/order', orderRouter);
app.use('/api', authRouter);

// Shortcuts
app.get('/login', (req,res)=> res.sendFile(path.join(__dirname, 'public', 'login.html')));
app.get('/dashboard', (req,res)=> res.sendFile(path.join(__dirname, 'public', 'dashboard.html')));

// Redirect base to login
app.get(['/', '/index'], (req,res)=> res.redirect('/login'));

const server = http.createServer(app);
const io = new Server(server, { cors: { origin: true } });
io.on('connection', s => s.emit('pageChange', 'view'));

const PORT = process.env.PORT || 4000;
server.listen(PORT, ()=> console.log('Server running on', PORT));
