const express = require('express');
const router = express.Router();

let pagesOrder = ['view', 'dashboard', 'update'];

router.get('/', (req, res) => {
  res.json({ order: pagesOrder });
});
router.post('/', (req, res) => {
  if (Array.isArray(req.body.order)) {
    pagesOrder = req.body.order;
    res.json({ status: 'ok', order: pagesOrder });
  } else {
    res.status(400).json({ status: 'error', message: 'Invalid order format' });
  }
});

module.exports = router;